#pragma once

#include "Mix/Private/Graphics/Common/DeviceObject.h"
#include "Mix/Graphics/IVertexLayout.h"

namespace Mix{ namespace Graphics{ namespace DX11{

	class Device;

	class VertexLayout : public Mix::Graphics::IVertexLayout, public Mix::Graphics::Common::DeviceObject
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::DX11::VertexLayout
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		static VertexLayout* CreateInstance(	Mix::Graphics::DX11::Device* pDevice,
												ID3D11InputLayout* pVertexLayout,
												const Mix::Graphics::VERTEX_ELEMENT* pElements,
												UInt32 elementCount,
												UInt32 stride );

	private:
		ID3D11InputLayout* m_pVertexLayout;
		Mix::STL::Vector<Mix::Memory::SECTION_GRAPHICS, Mix::Graphics::VERTEX_ELEMENT> m_ElementList;
		UInt32 m_ElementSemanticFlags;
		UInt32 m_Stride;

	private:
		VertexLayout(	Mix::Graphics::DX11::Device* pDevice,
						ID3D11InputLayout* pVertexLayout,
						const Mix::Graphics::VERTEX_ELEMENT* pElements,
						UInt32 elementCount,
						UInt32 stride );

		virtual ~VertexLayout( void );

	public:
		ID3D11InputLayout* GetInterface( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::IVertexBuffer
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual UInt32 GetElementCount( void ) const;
		virtual const Mix::Graphics::VERTEX_ELEMENT* GetElements( void ) const;
		virtual UInt32 GetElementSemanticFlags( void ) const;
		virtual UInt32 GetStride( void ) const;

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::IDeviceObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Mix::Graphics::IDeviceObject::TYPE GetType( void ) const;
	};

}}}
