#pragma once

#include "Mix/Private/Graphics/Common/DeviceObject.h"
#include "Mix/Graphics/IVertexShader.h"

namespace Mix{ namespace Graphics{ namespace DX11{

	class Device;

	class VertexShader : public Mix::Graphics::IVertexShader, public Mix::Graphics::Common::DeviceObject
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::DX11::VertexShader
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		static VertexShader* CreateInstance( Mix::Graphics::DX11::Device* pDevice, ID3D11VertexShader* pVertexShader, Mix::Memory::IBuffer* pInputSignature );

	private:
		ID3D11VertexShader* m_pVertexShader;
		Mix::Memory::IBuffer* m_pInputSignature;

	private:
		VertexShader( Mix::Graphics::DX11::Device* pDevice, ID3D11VertexShader* pVertexShader, Mix::Memory::IBuffer* pInputSignature );
		virtual ~VertexShader( void );

	public:
		ID3D11VertexShader* GetInterface( void );

		const void* GetInputSignature( void ) const;
		UIntT GetInputSignatureSize( void ) const;

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::IDeviceObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Mix::Graphics::IDeviceObject::TYPE GetType( void ) const;
	};

}}}
