#pragma once

#include "Mix/Private/Graphics/Common/DeviceObject.h"
#include "Mix/Graphics/IIndexBuffer.h"

namespace Mix{ namespace Graphics{ namespace DX9{

	class Device;

	class IndexBuffer : public Mix::Graphics::IIndexBuffer, public Mix::Graphics::Common::DeviceObject
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::DX9::IndexBuffer
		////////////////////////////////////////////////////////////////////////////////////////////////////

	private:
		Mix::Graphics::DX9::Device* m_pDevice;
		IDirect3DIndexBuffer9* m_pIndexBuffer;
		UInt8* m_pBuffer;
		Mix::Graphics::INDEX_FORMAT m_Format;
		D3DFORMAT m_D3DFormat;
		UInt32 m_Stride;
		UInt32 m_Capacity;
		UInt32 m_Count;
		Boolean m_bDynamic;
		UInt32 m_ResizeStep;
		UInt32 m_LockFlags;
		UInt8* m_pSource;
		Boolean m_bResize;

	public:
		static IndexBuffer* CreateInstance( Mix::Graphics::DX9::Device* pDevice,
											Mix::Graphics::INDEX_FORMAT format,
											D3DFORMAT d3dFormat,
											UInt32 count,
											Boolean bDynamic,
											UInt32 resizeStep,
											IDirect3DIndexBuffer9* pIndexBuffer );

	private:
		IndexBuffer(	Mix::Graphics::DX9::Device* pDevice,
						Mix::Graphics::INDEX_FORMAT format,
						D3DFORMAT d3dFormat,
						UInt32 count,
						Boolean bDynamic,
						UInt32 resizeStep,
						IDirect3DIndexBuffer9* pIndexBuffer );

		virtual ~IndexBuffer( void );

	public:
		HRESULT Initialize( const void* pInitialData );
		IDirect3DIndexBuffer9* GetInterface( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::Common::DeviceObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual void Invalidate( void );
		virtual void Validate( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::IIndexBuffer
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Boolean Lock( void );
		virtual void Unlock( void );

		virtual Boolean Push( const void* pData, UInt32 count );
		virtual void* Push( UInt32 count );

		virtual void Clear( void );

		virtual UInt32 GetCount( void ) const;
		virtual UInt32 GetCapacity( void ) const;

		virtual Mix::Graphics::INDEX_FORMAT GetFormat( void ) const;

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::IDeviceObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Mix::Graphics::IDeviceObject::TYPE GetType( void ) const;
	};

}}}
