#include "Mix/Private/Graphics/DX9/PixelShader.h"
#include "Mix/Private/Graphics/DX9/Device.h"

namespace Mix{ namespace Graphics{ namespace DX9{

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::DX9::PixelShader
////////////////////////////////////////////////////////////////////////////////////////////////////

PixelShader* PixelShader::CreateInstance( Mix::Graphics::DX9::Device* pDevice, IDirect3DPixelShader9* pPixelShader )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_GRAPHICS, PixelShader, pDevice, pPixelShader );
}

PixelShader::PixelShader( Mix::Graphics::DX9::Device* pDevice, IDirect3DPixelShader9* pPixelShader ) :
DeviceObject( pDevice ),
m_pPixelShader( pPixelShader )
{
}

PixelShader::~PixelShader( void )
{
	MIX_RELEASE( m_pPixelShader );
}

IDirect3DPixelShader9* PixelShader::GetInsterface( void )
{
	return m_pPixelShader;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::IDeviceObject
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Graphics::IDeviceObject::TYPE PixelShader::GetType( void ) const
{
	return Mix::Graphics::IDeviceObject::PIXEL_SHADER;
}

}}}
