#pragma once

#include "Mix/Private/Graphics/Common/DeviceObject.h"
#include "Mix/Graphics/IPixelShader.h"

namespace Mix{ namespace Graphics{ namespace DX9{

	class Device;

	class PixelShader : public Mix::Graphics::IPixelShader, public Mix::Graphics::Common::DeviceObject
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::DX9::PixelShader
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		static PixelShader* CreateInstance( Mix::Graphics::DX9::Device* pDevice, IDirect3DPixelShader9* pPixelShader );

	private:
		IDirect3DPixelShader9* m_pPixelShader;

	private:
		PixelShader( Mix::Graphics::DX9::Device* pDevice, IDirect3DPixelShader9* pPixelShader );
		virtual ~PixelShader( void );

	public:
		IDirect3DPixelShader9* GetInsterface( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::IDeviceObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Mix::Graphics::IDeviceObject::TYPE GetType( void ) const;
	};

}}}
