#include "Mix/Private/Graphics/DX9/TextureDepth.h"
#include "Mix/Private/Graphics/DX9/Device.h"

namespace Mix{ namespace Graphics{ namespace DX9{

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::DX9::TextureDepth
////////////////////////////////////////////////////////////////////////////////////////////////////

TextureDepth* TextureDepth::CreateInstance(	Mix::Graphics::DX9::Device* pDevice,
											UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
											D3DFORMAT d3dFormat, IDirect3DSurface9* pSurface )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_GRAPHICS, TextureDepth, pDevice, width, height, format, d3dFormat, pSurface );
}

TextureDepth::TextureDepth(	Mix::Graphics::DX9::Device* pDevice,
							UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
							D3DFORMAT d3dFormat, IDirect3DSurface9* pSurface ) :
DeviceObject( pDevice ),
m_pDevice( pDevice ),
m_Width( width ),
m_Height( height ),
m_Format( format ),
m_D3DFormat( d3dFormat ),
m_pSurface( pSurface )
{
	MIX_ADD_REF( m_pDevice );
}

TextureDepth::~TextureDepth( void )
{
	MIX_RELEASE( m_pSurface );
	MIX_RELEASE( m_pDevice );
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::DeviceObject
////////////////////////////////////////////////////////////////////////////////////////////////////

void TextureDepth::Invalidate( void )
{
	MIX_RELEASE( m_pSurface );
}

void TextureDepth::Validate( void )
{
	HRESULT ret;
	
	ret = m_pDevice->CreateDepthTexture( m_Width, m_Height, m_D3DFormat, &m_pSurface );
	if( ret != D3D_OK )
	{
		MIX_LOG_ERROR( L"fvXeNX`̕AɎs : Result[%s]", m_pDevice->GetD3DResultText( ret ) );
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::Texture
////////////////////////////////////////////////////////////////////////////////////////////////////

IDirect3DBaseTexture9* TextureDepth::GetInterface( void )
{
	return NULL;
}

IDirect3DSurface9* TextureDepth::GetSurface( UInt32 index )
{
	return m_pSurface;
}

UInt32 TextureDepth::GetSurfaceCount( void ) const
{
	return 1;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::ITexture
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Graphics::ITexture::DIMENSION_TYPE TextureDepth::GetDimensionType( void ) const
{
	return Mix::Graphics::ITexture::DIMENSION_PLANE;
}

Mix::Graphics::ITexture::BIND_TYPE TextureDepth::GetBindType( void ) const
{
	return Mix::Graphics::ITexture::BIND_DEPTH;
}

UInt32 TextureDepth::GetAccessFlags( void ) const
{
	return Mix::Graphics::ITexture::ACCESS_GPU_WRITE;
}

UInt32 TextureDepth::GetWidth( void ) const
{
	return m_Width;
}

UInt32 TextureDepth::GetHeight( void ) const
{
	return m_Height;
}

Mix::Graphics::FORMAT TextureDepth::GetFormat( void ) const
{
	return m_Format;
}

const wchar_t* TextureDepth::GetFilePath( void ) const
{
	return Mix::STR_NULL;
}

Boolean TextureDepth::Lock( Mix::Graphics::ITexture::LOCK& lock )
{
	return False;
}

void TextureDepth::Unlock( void )
{
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::IDeviceObject
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Graphics::IDeviceObject::TYPE TextureDepth::GetType( void ) const
{
	return Mix::Graphics::IDeviceObject::TEXTURE;
}

}}}
