#include "Mix/Private/Graphics/DX9/TexturePlane.h"
#include "Mix/Private/Graphics/DX9/Device.h"

namespace Mix{ namespace Graphics{ namespace DX9{

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::DX9::TexturePlane
////////////////////////////////////////////////////////////////////////////////////////////////////

TexturePlane* TexturePlane::CreateInstance(	Mix::Graphics::DX9::Device* pDevice,
										const wchar_t* pFilePath,
										UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
										IDirect3DTexture9* pD3DTexture, D3DFORMAT d3dFormat )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_GRAPHICS, TexturePlane, pDevice, pFilePath, width, height, format, pD3DTexture, d3dFormat );
}

TexturePlane::TexturePlane(	Mix::Graphics::DX9::Device* pDevice,
						const wchar_t* pFilePath,
						UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
						IDirect3DTexture9* pD3DTexture, D3DFORMAT D3DFormat ) :
DeviceObject( pDevice ),
m_pDevice( NULL ),
m_FilePath( pFilePath ),
m_Width( width ),
m_Height( height ),
m_Format( format ),
m_D3DFormat( D3DFormat ),
m_pTexture( pD3DTexture ),
m_LockFlags( D3DLOCK_DISCARD ),
m_bLock( False )
{
	MIX_ASSERT( pDevice != NULL );

	MIX_ADD_REF( pDevice );
	m_pDevice = pDevice;
}

TexturePlane::~TexturePlane( void )
{
	MIX_RELEASE( m_pTexture );
	MIX_RELEASE( m_pDevice );
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::DeviceObject
////////////////////////////////////////////////////////////////////////////////////////////////////

void TexturePlane::Invalidate( void )
{
	if( m_FilePath.GetNum() == 0 )
	{
		MIX_RELEASE( m_pTexture );
	}
}

void TexturePlane::Validate( void )
{
	if( m_FilePath.GetNum() == 0 )
	{
		HRESULT ret;

		ret = m_pDevice->CreateDynamicTexture( m_Width, m_Height, m_D3DFormat, &m_pTexture );
		if( ret != D3D_OK )
		{
			MIX_LOG_ERROR( L"eNX`̕AɎs : Result[%s]", m_pDevice->GetD3DResultText( ret ) );
		}
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::Texture
////////////////////////////////////////////////////////////////////////////////////////////////////

IDirect3DBaseTexture9* TexturePlane::GetInterface( void )
{
	return m_pTexture;
}

IDirect3DSurface9* TexturePlane::GetSurface( UInt32 index )
{
	return NULL;
}

UInt32 TexturePlane::GetSurfaceCount( void ) const
{
	return 0;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::ITexture
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Graphics::ITexture::DIMENSION_TYPE TexturePlane::GetDimensionType( void ) const
{
	return ITexture::DIMENSION_PLANE;
}

Mix::Graphics::ITexture::BIND_TYPE TexturePlane::GetBindType( void ) const
{
	return ITexture::BIND_DEFAULT;
}

UInt32 TexturePlane::GetAccessFlags( void ) const
{
	return ITexture::ACCESS_GPU_READ;
}

UInt32 TexturePlane::GetWidth( void ) const
{
	return m_Width;
}

UInt32 TexturePlane::GetHeight( void ) const
{
	return m_Height;
}

Mix::Graphics::FORMAT TexturePlane::GetFormat( void ) const
{
	return m_Format;
}

const wchar_t* TexturePlane::GetFilePath( void ) const
{
	return m_FilePath.GetConstPtr();
}

Boolean TexturePlane::Lock( Mix::Graphics::ITexture::LOCK& lock )
{
	return False;
}

void TexturePlane::Unlock( void )
{
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::IDeviceObject
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Graphics::IDeviceObject::TYPE TexturePlane::GetType( void ) const
{
	return Mix::Graphics::IDeviceObject::TEXTURE;
}

}}}
