#pragma once

#include "Mix/Private/Graphics/Common/DeviceObject.h"
#include "Mix/Private/Graphics/DX9/Texture.h"

namespace Mix{ namespace Graphics{ namespace DX9{

	class Device;

	class TextureTargetL : public Mix::Graphics::DX9::Texture, public Mix::Graphics::Common::DeviceObject
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::DX9::TextureTargetL
		////////////////////////////////////////////////////////////////////////////////////////////////////

	private:
		Mix::Graphics::DX9::Device*	m_pDevice;

		Mix::Graphics::FORMAT		m_Format;
		UInt32						m_Width;
		UInt32						m_Height;
		Boolean						m_bLock;

		IDirect3DSurface9*			m_pD3DSurface;
		D3DFORMAT					m_D3DFormat;

	public:
		static TextureTargetL* CreateInstance(	Mix::Graphics::DX9::Device* pDevice,
												UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
												IDirect3DSurface9* pD3DSurface, D3DFORMAT d3dFormat );

	private:
		TextureTargetL(	Mix::Graphics::DX9::Device* pDevice,
						UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
						IDirect3DSurface9* pD3DSurface, D3DFORMAT d3dFormat );

		virtual ~TextureTargetL( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::DeviceObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual void Invalidate( void );
		virtual void Validate( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::Texture
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual IDirect3DBaseTexture9* GetInterface( void );
		virtual IDirect3DSurface9* GetSurface( UInt32 index );
		virtual UInt32 GetSurfaceCount( void ) const;

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::ITexture
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Mix::Graphics::ITexture::DIMENSION_TYPE GetDimensionType( void ) const;
		virtual Mix::Graphics::ITexture::BIND_TYPE GetBindType( void ) const;
		virtual UInt32 GetAccessFlags( void ) const;
		virtual UInt32 GetWidth( void ) const;
		virtual UInt32 GetHeight( void ) const;
		virtual Mix::Graphics::FORMAT GetFormat( void ) const;
		virtual const wchar_t* GetFilePath( void ) const;
		virtual Boolean Lock( Mix::Graphics::ITexture::LOCK& lock );
		virtual void Unlock( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::IDeviceObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Mix::Graphics::IDeviceObject::TYPE GetType( void ) const;
	};

}}}
