#pragma once

#include "Mix/Private/Graphics/Common/DeviceObject.h"
#include "Mix/Graphics/IVertexBuffer.h"

namespace Mix{ namespace Graphics{ namespace DX9{

	class Device;

	class VertexBuffer : public Mix::Graphics::IVertexBuffer, public Mix::Graphics::Common::DeviceObject
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::DX9::VertexBuffer
		////////////////////////////////////////////////////////////////////////////////////////////////////

	private:
		Mix::Graphics::DX9::Device* m_pDevice;
		IDirect3DVertexBuffer9* m_pVertexBuffer;
		UInt8* m_pBuffer;
		UInt32 m_Stride;
		UInt32 m_Capacity;
		UInt32 m_Count;
		Boolean m_bDynamic;
		UInt32 m_ResizeStep;
		UInt32 m_LockFlags;
		UInt8* m_pSource;
		Boolean m_bResize;

	public:
		static VertexBuffer* CreateInstance(	Mix::Graphics::DX9::Device* pDevice,
												UInt32 count, UInt32 stride,
												Boolean bDynamic, UInt32 resizeStep,
												IDirect3DVertexBuffer9* pVertexBuffer );

	private:
		VertexBuffer(	Mix::Graphics::DX9::Device* pDevice,
						UInt32 count, UInt32 stride,
						Boolean bDynamic, UInt32 resizeStep,
						IDirect3DVertexBuffer9* pVertexBuffer );

		virtual ~VertexBuffer( void );

	public:
		HRESULT Initialize( const void* pInitialData );
		IDirect3DVertexBuffer9* GetInterface( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::DeviceObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual void Invalidate( void );
		virtual void Validate( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::IVertexBuffer
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Boolean Lock( void );
		virtual void Unlock( void );

		virtual Boolean Push( const void* pData, UInt32 count );
		virtual void* Push( UInt32 count );

		virtual void Clear( void );

		virtual UInt32 GetStride( void ) const;

		virtual UInt32 GetCount( void ) const;
		virtual UInt32 GetCapacity( void ) const;

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::IDeviceObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Mix::Graphics::IDeviceObject::TYPE GetType( void ) const;
	};

}}}
