#include "Mix/Private/Graphics/DX9/VertexShader.h"
#include "Mix/Private/Graphics/DX9/Device.h"

namespace Mix{ namespace Graphics{ namespace DX9{

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::DX9::VertexShader
////////////////////////////////////////////////////////////////////////////////////////////////////

VertexShader* VertexShader::CreateInstance( Mix::Graphics::DX9::Device* pDevice, IDirect3DVertexShader9* pVertexShader )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_GRAPHICS, VertexShader, pDevice, pVertexShader );
}

VertexShader::VertexShader( Mix::Graphics::DX9::Device* pDevice, IDirect3DVertexShader9* pVertexShader ) :
DeviceObject( pDevice ),
m_pVertexShader( pVertexShader )
{
}

VertexShader::~VertexShader( void )
{
	MIX_RELEASE( m_pVertexShader );
}

IDirect3DVertexShader9* VertexShader::GetInsterface( void )
{
	return m_pVertexShader;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::IDeviceObject
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Graphics::IDeviceObject::TYPE VertexShader::GetType( void ) const
{
	return Mix::Graphics::IDeviceObject::VERTEX_SHADER;
}

}}}
