#pragma once

#include "Mix/Private/Graphics/Common/DeviceObject.h"
#include "Mix/Graphics/IVertexShader.h"

namespace Mix{ namespace Graphics{ namespace DX9{

	class Device;

	class VertexShader : public Mix::Graphics::IVertexShader, public Mix::Graphics::Common::DeviceObject
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::DX9::VertexShader
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		static VertexShader* CreateInstance( Mix::Graphics::DX9::Device* pDevice, IDirect3DVertexShader9* pVertexShader );

	private:
		IDirect3DVertexShader9* m_pVertexShader;

	private:
		VertexShader( Mix::Graphics::DX9::Device* pDevice, IDirect3DVertexShader9* pVertexShader );
		virtual ~VertexShader( void );

	public:
		IDirect3DVertexShader9* GetInsterface( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::IDeviceObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Mix::Graphics::IDeviceObject::TYPE GetType( void ) const;
	};

}}}
