#include "Mix/Private/HID/Gamepad.h"

namespace Mix{ namespace HID{

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Gamepad
//////////////////////////////////////////////////////////////////////////////////////////////////////////////

const Mix::Vector2 Gamepad::DUMMY_STICK_STATE = Mix::Vector2( 0.0f, 0.0f );

Gamepad::Gamepad( void )
{
	SetStickDeadZone( Mix::HID::GAMEPAD_LEFT, XINPUT_GAMEPAD_LEFT_THUMB_DEADZONE );
	SetStickDeadZone( Mix::HID::GAMEPAD_RIGHT, XINPUT_GAMEPAD_RIGHT_THUMB_DEADZONE );
}

Gamepad::~Gamepad( void )
{
}

void Gamepad::SetStickDeadZone( UInt32 index, Int16 deadZone )
{
	if( index < Mix::HID::GAMEPAD_FINGER_MAX )
	{
		Gamepad::STICK_CAP* pCap = &( m_StickCap[index] );
		
		deadZone = MIX_CLAMP( deadZone, 0, Mix::HID::GAMEPAD_STICK_RESOLUTION );

		pCap->deadZone = XINPUT_GAMEPAD_LEFT_THUMB_DEADZONE;
		pCap->minusNorm = static_cast<Float32>( 32768 - deadZone );
		pCap->plusNorm = static_cast<Float32>( 32767 - deadZone );
	}
}

Int16 Gamepad::GetStickDeadZone( UInt32 index ) const
{
	if( index >= Mix::HID::GAMEPAD_FINGER_MAX )
	{
		return Mix::HID::GAMEPAD_STICK_RESOLUTION;
	}

	return m_StickCap[index].deadZone;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
// NullGamepad
//////////////////////////////////////////////////////////////////////////////////////////////////////////////

NullGamepad* NullGamepad::CreateInstance( void )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_GENERAL, NullGamepad );
}

NullGamepad::NullGamepad( void )
{
}

NullGamepad::~NullGamepad( void )
{
}

void NullGamepad::Update( void )
{
}

void NullGamepad::Dispose( void )
{
}

UInt32 NullGamepad::GetButtonState( UInt32 index ) const
{
	return 0;
}

Float32 NullGamepad::GetTriggerState( UInt32 index ) const
{
	return 0.0f;
}

const Mix::Vector2& NullGamepad::GetStickState( UInt32 index ) const
{
	return Gamepad::DUMMY_STICK_STATE;
}

Boolean NullGamepad::IsAvailable( void ) const
{
	return False;
}

Mix::HID::GAMEPAD_API NullGamepad::GetAPI( void ) const
{
	return Mix::HID::GAMEPAD_UNKNOWN;
}

UInt8 NullGamepad::GetSourceButtonValue( UInt32 index ) const
{
	return 0;
}

UInt32 NullGamepad::GetSourcePovValue( UInt32 index ) const
{
	return 0;
}

void NullGamepad::SetButtonAssignment( UInt32 targetIndex, UInt32 sourceIndex )
{
}

UInt32 NullGamepad::GetButtonAssignment( UInt32 targetIndex ) const
{
	return 0xFFFFFFFF;
}

void NullGamepad::SetTriggerAssignment( UInt32 targetIndex, UInt32 sourceIndex )
{
}

UInt32 NullGamepad::GetTriggerAssignment( UInt32 targetIndex ) const
{
	return 0xFFFFFFFF;
}

void NullGamepad::SetTriggerThreshold( UInt32 index, UInt8 threshold )
{
}

UInt8 NullGamepad::GetTriggerThreshold( UInt32 index ) const
{
	return Mix::HID::GAMEPAD_TRIGGER_RESOLUTION;
}

}}
