#include "Mix/Private/HID/Manager.h"

namespace Mix{ namespace HID{

Manager* Manager::CreateInstance( void )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_GENERAL, Manager );
}

Manager::Manager( void )
{
}

Manager::~Manager( void )
{
}

Boolean Manager::Initialize( HWND hWnd, UInt32 flags, Mix::UserFile* pSysReport )
{
	//^Cg
	pSysReport->WriteLine( L"////////////////////////////////////////////////////////////////////////////////////////////////////" );
	pSysReport->WriteLine( L"//                                                                                            //" );
	pSysReport->WriteLine( L"////////////////////////////////////////////////////////////////////////////////////////////////////" );
	pSysReport->WriteLine( L"" );

	if( MIX_TESTBIT( flags, Mix::EC_KEYBOARD | Mix::EC_MOUSE ) != 0 )
	{
		if( m_RawInputMgr.Start( hWnd, flags, pSysReport ) == False )
		{
			return False;
		}
	}

	if( MIX_TESTBIT( flags, Mix::EC_GAMEPAD ) == Mix::EC_GAMEPAD )
	{
		if( m_GamepadMgr.Start( hWnd, pSysReport ) == False )
		{
			return False;
		}
	}

	return True;
}

void Manager::Dispose( void )
{
	m_GamepadMgr.Terminate();
	m_RawInputMgr.Terminate();
}

void Manager::MessageProc( UInt32 msg, WPARAM wParam, LPARAM lParam )
{
	m_RawInputMgr.MessageProc( msg, wParam, lParam );
}

void Manager::Update( void )
{
	m_RawInputMgr.Update();
	m_GamepadMgr.Update();
}

Boolean Manager::GetKeyboard( Mix::HID::IKeyboard** ppKeyboard )
{
	return m_RawInputMgr.GetKeyboard( ppKeyboard );
}

Boolean Manager::GetMouse( Mix::HID::IMouse** ppMouse )
{
	return m_RawInputMgr.GetMouse( ppMouse );
}

Boolean Manager::GetGamepad( UInt32 port, Mix::HID::IGamepad** ppGamepad )
{
	return m_GamepadMgr.Get( port, ppGamepad );
}

Boolean Manager::FindGamepad( Mix::HID::GAMEPAD_API api, Mix::HID::IGamepad** ppGamepad )
{
	return m_GamepadMgr.Find( api, ppGamepad );
}

}}
