#pragma once

#include "Mix/HID/IManager.h"
#include "Mix/Private/HID/RawInputManager.h"
#include "Mix/Private/HID/GamepadManager.h"

namespace Mix{ namespace HID{

	class Manager : public Mix::HID::IManager
	{
	public:
		static Manager* CreateInstance( void );

	private:
		Mix::HID::RawInputManager m_RawInputMgr;
		Mix::HID::GamepadManager m_GamepadMgr;

	private:
		Manager( void );
		virtual ~Manager( void );

	public:
		Boolean Initialize( HWND hWnd, UInt32 flags, Mix::UserFile* pSysReport );
		void Dispose( void );

		void MessageProc( UInt32 msg, WPARAM wParam, LPARAM lParam );
		void Update( void );

	public:
		virtual Boolean GetKeyboard( Mix::HID::IKeyboard** ppKeyboard );
		virtual Boolean GetMouse( Mix::HID::IMouse** ppMouse );
		virtual Boolean GetGamepad( UInt32 port, Mix::HID::IGamepad** ppGamepad );
		virtual Boolean FindGamepad( Mix::HID::GAMEPAD_API api, Mix::HID::IGamepad** ppGamepad );
	};

}}
