#pragma once

namespace Mix{ namespace HID{

	class Keyboard;
	class Mouse;

	class RawInputManager
	{
	private:
		static const wchar_t* FAILED_INITIALIZE;

	private:
		HWND						m_hWnd;

		UInt8*						m_pBuffer;
		UInt32						m_BufferSize;

		Mix::HID::Keyboard*	m_pKeyboard;
		Mix::HID::Mouse* m_pMouse;

	private:
		Boolean GetDeviceDesc( const TCHAR* pszClass, const TCHAR* pszKeyName, Mix::StringW& name );

	public:
		MIX_DECLARE_ALLOCATOR();

		RawInputManager( void );
		virtual ~RawInputManager( void );

		Boolean Start( HWND hWnd, UInt32 flags, Mix::UserFile* pSysReport );
		void Terminate( void );

		void MessageProc( UInt32 msg, WPARAM wParam, LPARAM lParam );
		void Update( void );

		Boolean GetKeyboard( Mix::HID::IKeyboard** ppKeyboard );
		Boolean GetMouse( Mix::HID::IMouse** ppMouse );
	};

}}
