#pragma once

#include "Mix/Private/IO/Controller.h"

namespace Mix{ namespace IO{

	class Archive;

	class ArchiveController : public Mix::IO::Controller
	{
	public:
		static ArchiveController* CreateInstance( const wchar_t* fileName, Mix::IO::Archive* pArchive, UInt64 head, UInt64 size );

	private:
		Mix::IO::Archive* m_pArchive;
		UInt64 m_Head;

	private:
		MIX_DECLARE_ALLOCATOR();

		ArchiveController( const wchar_t* fileName, Mix::IO::Archive* pArchive, UInt64 head, UInt64 size );
		virtual ~ArchiveController( void );

	public:
		Mix::IO::Archive* GetArchivePointer( void ) const;

	public:
		virtual Boolean Open( Controller::MODE mode );
		virtual void Close( void );
		virtual Boolean IsOpen( void ) const;

		virtual UInt32 Read( void* pReadBuffer, UInt32 readSize );
		virtual UInt32 Write( const void* pWriteBuffer, UInt32 writeSize );

		virtual UInt64 Seek( Mix::IO::SEEK_METHOD seekMethod, Int64 offset );

		virtual Boolean IsArchive( void ) const;
	};

}}
