#pragma once

#include <map>
#include <list>

#include "Mix/CriticalSection.h"
#include "Mix/Private/IO/Manager.h"
#include "Mix/Private/IO/Controller.h"

namespace Mix{ namespace IO{

	class BroadManager : public Mix::IO::Manager
	{
	private:
		typedef std::map<Mix::StringW, Mix::IO::Controller*> ControllerMap;

	public:
		static BroadManager* CreateInstance( void );

	private:
		Mix::CriticalSection m_MySync;
		BroadManager::ControllerMap m_CtrlMap;

	private:
		BroadManager( void );
		virtual ~BroadManager( void );

		Mix::IO::Controller* OpenController( const wchar_t* pFilePath, Mix::IO::Controller::MODE mode, const wchar_t* pFailedMsg );
		Mix::Memory::IBuffer* CreateBufferFromFile( const wchar_t* pFilePath, const wchar_t* pFailedMsg );

	public:
		virtual Boolean MountArchive( const wchar_t* pFilePath );
		virtual Boolean MountDirectory( const wchar_t* pDirectoryPath );
		virtual Boolean MountFile( const wchar_t* pFilePath );

		virtual Boolean ExistsFile( const wchar_t* pFilePath );

		virtual Boolean CreateBufferFromFile( const wchar_t* pFilePath, Mix::Memory::IBuffer** ppBuffer );

		virtual Boolean CreateFileReader( const wchar_t* pFilePath, Mix::IO::IReader** ppReader );
		virtual Boolean CreateBufferedReader( const wchar_t* pFilePath, Mix::IO::IReader** ppReader );
		virtual Boolean CreateBufferedReader( const wchar_t* pName, Mix::Memory::IBuffer* pBuffer, Mix::IO::IReader** ppReader );

		virtual Boolean CreateFileWriter( const wchar_t* pFilePath, Mix::IO::IWriter** ppWriter );
	};

}}
