#pragma once

#include "Mix/Reference.h"

namespace Mix{ namespace IO{

	class Controller : public Mix::Reference
	{
	public:
		enum MODE
		{
			READ			= 0,
			WRITE			= 1,
			WRITE_ALWAYS	= 2,
		};

	protected:
		Mix::String m_FilePath;
		UInt64 m_Pos;
		UInt64 m_Size;

	protected:
		Controller( const wchar_t* filePath );
		virtual ~Controller( void );

	public:
		UInt64 GetPos( void ) const;
		UInt64 GetSize( void ) const;
		const wchar_t* GetFilePath( void ) const;

	public:
		virtual Boolean Open( MODE mode ) = 0;
		virtual void Close( void ) = 0;
		virtual Boolean IsOpen( void ) const = 0;

		virtual UInt32 Read( void* pReadBuffer, UInt32 readSize ) = 0;
		virtual UInt32 Write( const void* pWriteBuffer, UInt32 writeSize ) = 0;

		virtual UInt64 Seek( Mix::IO::SEEK_METHOD seekMethod, Int64 offset ) = 0;

		virtual Boolean IsArchive( void ) const = 0;
	};

}}
