#include "Mix/Private/IO/FileReader.h"
#include "Mix/Private/IO/Controller.h"

namespace Mix{ namespace IO{

FileReader* FileReader::CreateInstance( const wchar_t* pFilePath, Mix::IO::Controller* pCtrl )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_GENERAL, FileReader, pFilePath, pCtrl );
}

FileReader::FileReader( const wchar_t* pFilePath, Mix::IO::Controller* pCtrl ) :
m_FilePath( pFilePath ),
m_pCtrl( pCtrl )
{
	MIX_ASSERT( pCtrl != NULL );

	MIX_ADD_REF( pCtrl );
	m_pCtrl = pCtrl;
}

FileReader::~FileReader( void )
{
	m_pCtrl->Close();
	MIX_RELEASE( m_pCtrl );
}

UInt32 FileReader::Read( void* pReadBuffer, UInt32 readSize )
{
	return m_pCtrl->Read( pReadBuffer, readSize );
}

UInt64 FileReader::Seek( Mix::IO::SEEK_METHOD seekMethod, Int64 offset )
{
	return m_pCtrl->Seek( seekMethod, offset );
}

UInt64 FileReader::GetPos( void ) const
{
	return m_pCtrl->GetPos();
}

UInt64 FileReader::GetSize( void ) const
{
	return m_pCtrl->GetSize();
}

const wchar_t* FileReader::GetFilePath( void ) const
{
	return m_FilePath.GetConstPtr();
}

Boolean FileReader::Clone( Mix::IO::IReader** ppReader )
{
	return False;
}

Mix::IO::IStream::ACCESS_TYPE FileReader::GetAccessType( void ) const
{
	return Mix::IO::IStream::A_READ;
}

Mix::IO::IStream::SOURCE_TYPE FileReader::GetSourceType( void ) const
{
	return Mix::IO::IStream::S_FILE;
}

}}
