#pragma once

#include "Mix/IO/IManager.h"

namespace Mix{ namespace IO{

	class Manager : public Mix::IO::IManager
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::File::Manager
		////////////////////////////////////////////////////////////////////////////////////////////////////

	protected:
		// pX̃tO
		enum PATH_FLAG
		{
			P_DIR	= 0x00000001,	// w肳ꂽpX̓fBNg\
			P_LOW	= 0x00000002,	// pXɕϊ
		};

	protected:
		Mix::StringW m_RootDirectoryPath;
		Mix::StringW m_UserDirectoryPath;

	protected:
		virtual ~Manager( void );

		Boolean CreateDirectory( const wchar_t* pFailedMsg, const wchar_t* pDirectoryPath );
		Boolean ModifyPath( UInt32 flags, const wchar_t* pSrcPath, Mix::StringW& destPath );

	public:
		Boolean Initialize( const wchar_t* pRootDirPath, const wchar_t* pUserDirPath );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::File::IManager
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual const wchar_t* GetRootDirectoryPath( void ) const;
		virtual const wchar_t* GetUserDirectoryPath( void ) const;

	protected:
		static const wchar_t* FAILED_INITIALIZE;
		static const wchar_t* FAILED_GETABSPATH;
		static const wchar_t* FAILED_EXISTFILE;
		static const wchar_t* FAILED_CREATEFILEREADER;
		static const wchar_t* FAILED_CREATEFILEWRITER;
		static const wchar_t* FAILED_CREATEBUFFEREDREADER;
		static const wchar_t* FAILED_CREATEFILEBUFFER;

		static const wchar_t* MSG_DIR_PATH_NOT_SOLVE;
		static const wchar_t* MSG_FILE_PATH_NOT_SOLVE;
		static const wchar_t* MSG_FILE_NOT_OPEN;
		static const wchar_t* MSG_FILE_NOT_READ;
		static const wchar_t* MSG_FILE_IN_USE;
		static const wchar_t* MSG_FILE_SIZE_LARGE;
	};

}}
