#pragma once

#include "Mix/Private/UserFile.h"

namespace Mix{

	class Logger
	{
	public:
		enum LEVEL
		{
			L_INFO			= 0,	//
			L_INFO_FORCE	= 1,	//([XłOƂĕ\)
			L_WARNING		= 2,	//x
			L_ERROR			= 3,	//G[
		};

		enum FLAG
		{
			F_DEVELOP		= 0x00000001,
			F_NO_OVERLAP	= 0x00000002,
		};

	private:
		enum VALUE
		{
			MAX_CHAR = 4096,
			PAR_SIZE = 2,
		};

	private:
		static Logger* g_pThis;

	public:
		static Boolean CreateInstance( const wchar_t* userFolderName, const wchar_t* logFileName );
		static void ReleaseInstance( void );
		static Logger* Instance( void );

	private:
		Boolean m_bInit;
		Mix::String m_PreLog;
		Int32 m_ParCount;

#ifndef _DEBUG
		Mix::UserFile m_File;
#endif //_DEBUG

	public:
		MIX_DECLARE_ALLOCATOR();

		Logger( void );

	public:
		void WriteText( Mix::Logger::LEVEL level, UInt32 flags, const wchar_t* format, ... );
		void WriteSectionLine( Mix::Logger::LEVEL level, UInt32 flags );
		void WriteSctionStart( Mix::Logger::LEVEL level, UInt32 flags, const wchar_t* format, ... );
		void WriteSctionEnd( Mix::Logger::LEVEL level, UInt32 flags );
		void Par( Int32 count );

	private:
		Boolean Initialize( const wchar_t* userFolderName, const wchar_t* logFileName );
		void Finalize( void );

		void InternalWriteText( Mix::Logger::LEVEL level, UInt32 flags, const wchar_t* text );
	};

}
