#include "Mix/Private/Memory/Buffer.h"

namespace Mix{ namespace Memory{

Buffer* Buffer::CreateInstance( void )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_GENERAL, Buffer );
}

Buffer::Buffer( void ) :
m_pBuffer( NULL ),
m_Size( 0 )
{
}

Buffer::~Buffer( void )
{
	if( m_pBuffer != NULL )
	{
		MIX_LIB_FREE( m_pBuffer );
	}
}

Boolean Buffer::Create( UInt16 section, UIntT size )
{
	if( m_pBuffer != NULL )
	{
		return False;
	}

	m_pBuffer = MIX_LIB_MALLOC( section, size );
	if( m_pBuffer == NULL )
	{
		return False;
	}

	m_Size = size;
	Mix::Memory::Zero( m_pBuffer, m_Size );

	return True;
}

const void* Buffer::GetConstPointer( void ) const
{
	return m_pBuffer;
}

void* Buffer::GetPointer( void ) const
{
	return m_pBuffer;
}

UIntT Buffer::GetSize( void ) const
{
	return m_Size;
}

}}
