#include "Mix/Private/Memory/System.h"

namespace Mix{ namespace Memory{

#ifndef MIX_USE_WIN_MALLOC

mspace System::g_Spaces[System::SECTION_TYPE_MAX];

System::System( void )
{
	System::Initialize();
}

System::~System( void )
{
	System::Terminate();
}

void System::Initialize( void )
{
	System::g_Spaces[Mix::Memory::SECTION_DEFAULT] = create_mspace( 1024 * 1024, 0 );
	System::g_Spaces[Mix::Memory::SECTION_LIBRARY] = create_mspace( 1024 * 1024, 0 );
	System::g_Spaces[Mix::Memory::SECTION_MISC] = create_mspace( 1024 * 1024, 0 );
#ifdef _DEBUG
	System::g_Spaces[Mix::Memory::SECTION_DEBUG] = create_mspace( 1024 * 1024, 0 );
#endif //_DEBUG
}

void System::Terminate( void )
{
	destroy_mspace( System::g_Spaces[Mix::Memory::SECTION_DEFAULT] );
	destroy_mspace( System::g_Spaces[Mix::Memory::SECTION_LIBRARY] );
	destroy_mspace( System::g_Spaces[Mix::Memory::SECTION_MISC] );
#ifdef _DEBUG
	destroy_mspace( System::g_Spaces[Mix::Memory::SECTION_DEBUG] );
#endif //_DEBUG
}

#pragma warning( disable: 4074 )

#if defined(__cplusplus) && defined(__GNUC__)
	System init __attribute__((init_priority( 111 )));
#elif defined (_MSC_VER)
	#pragma init_seg(compiler)
	System init;
#else
	#error not supported.
#endif

#endif //MIX_USE_WIN_MALLOC

}}
