#include "Mix/Private/PCH.h"
#include "Mix/Private/Engine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
// Global values
////////////////////////////////////////////////////////////////////////////////////////////////////

namespace Mix
{
	static HINSTANCE g_hInternalInstance = NULL;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// DLLMain
////////////////////////////////////////////////////////////////////////////////////////////////////

#ifdef _MIX_DLL

BOOL WINAPI DllMain( HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved )
{
	switch( fdwReason )
	{
	case DLL_PROCESS_ATTACH:
		Mix::g_hInternalInstance = hinstDLL;
		break;
	}

	return TRUE;
}

#endif //_MIX_DLL

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix
////////////////////////////////////////////////////////////////////////////////////////////////////

namespace Mix{

	HINSTANCE GetInternalInstanceHandle( void )
	{
		return g_hInternalInstance;
	}

	Mix::Engine* GetInternalEnginePtr( void )
	{
		MIX_ASSERT( Mix::Engine::GetInstance() != NULL );
		return Mix::Engine::GetInstance();
	}

}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::IO
////////////////////////////////////////////////////////////////////////////////////////////////////

namespace Mix{ namespace IO{

	Mix::IO::Manager* GetInternalManagerPtr( void )
	{
		MIX_ASSERT( Mix::Engine::GetInstance() != NULL );
		return Mix::Engine::GetInstance()->GetInternalIOManagerPtr();
	}

}}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::HID
////////////////////////////////////////////////////////////////////////////////////////////////////

namespace Mix{ namespace HID{

	Mix::HID::Manager* GetInternalManagerPtr( void )
	{
		MIX_ASSERT( Mix::Engine::GetInstance() != NULL );
		return Mix::Engine::GetInstance()->GetInternalHIDManagerPtr();
	}

}}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Dynamics
////////////////////////////////////////////////////////////////////////////////////////////////////

namespace Mix{ namespace Dynamics{

	Mix::Dynamics::Manager* GetInternalManagerPtr( void )
	{
		MIX_ASSERT( Mix::Engine::GetInstance() != NULL );
		return Mix::Engine::GetInstance()->GetInternalDynamicsManagerPtr();
	}

}}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics
////////////////////////////////////////////////////////////////////////////////////////////////////

namespace Mix{ namespace Graphics{

	Mix::Graphics::Common::Manager* GetInternalManagerPtr( void )
	{
		MIX_ASSERT( Mix::Engine::GetInstance() != NULL );
		return Mix::Engine::GetInstance()->GetInternalGraphicsManagerPtr();
	}

}}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Sound
////////////////////////////////////////////////////////////////////////////////////////////////////

namespace Mix{ namespace Sound{

	Mix::Sound::Manager* GetInternalManagerPtr( void )
	{
		MIX_ASSERT( Mix::Engine::GetInstance() != NULL );
		return Mix::Engine::GetInstance()->GetInternalSoundManagerPtr();
	}

}}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Parallel
////////////////////////////////////////////////////////////////////////////////////////////////////

namespace Mix{ namespace Parallel{

	Mix::Parallel::Manager* GetInternalManagerPtr( void )
	{
		MIX_ASSERT( Mix::Engine::GetInstance() != NULL );
		return Mix::Engine::GetInstance()->GetInternalParallelManagerPtr();
	}

}}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Scene
////////////////////////////////////////////////////////////////////////////////////////////////////

namespace Mix{ namespace Scene{

	Mix::Scene::Common::Manager* GetInternalManagerPtr( void )
	{
		MIX_ASSERT( Mix::Engine::GetInstance() != NULL );
		return Mix::Engine::GetInstance()->GetInternalSceneManagerPtr();
	}

}}
