#include "Mix/Rectangle.h"

using namespace Mix;

Rectangle::Rectangle( void ) :
x( 0 ),
y( 0 ),
width( 0 ),
height( 0 )
{
}

Rectangle::Rectangle( Int32 rx, Int32 ry, Int32 rw, Int32 rh ) :
x( rx ),
y( ry ),
width( rw ),
height( rh )
{
}

Rectangle::Rectangle( const Mix::Rectangle& rect ) :
x( rect.x ),
y( rect.y ),
width( rect.width ),
height( rect.height )
{
}

Rectangle::Rectangle( const Mix::RectangleF& rect ) :
x( static_cast<Int32>( rect.x ) ),
y( static_cast<Int32>( rect.y ) ),
width( static_cast<Int32>( rect.width ) ),
height( static_cast<Int32>( rect.height ) )
{
}

Boolean Rectangle::operator == ( const Rectangle& rect ) const
{
	if( ( x != rect.x ) ||
		( y != rect.y ) ||
		( width != rect.width ) ||
		( height != rect.height ) )
	{
		return False;
	}

	return True;
}

Boolean Rectangle::operator != ( const Rectangle& rect ) const
{
	if( ( x != rect.x ) ||
		( y != rect.y ) ||
		( width != rect.width ) ||
		( height != rect.height ) )
	{
		return True;
	}

	return False;
}

Mix::Rectangle& Rectangle::operator = ( const Mix::Rectangle& rect )
{
	x = rect.x;
	y = rect.y;
	width = rect.width;
	height = rect.height;

	return *this;
}

Mix::Rectangle& Rectangle::operator = ( const Mix::RectangleF& rect )
{
	x = static_cast<Int32>( rect.x );
	y = static_cast<Int32>( rect.y );
	width = static_cast<Int32>( rect.width );
	height = static_cast<Int32>( rect.height );

	return *this;
}

void Rectangle::Set( Int32 rx, Int32 ry, Int32 rw, Int32 rh )
{
	x = rx;
	y = ry;
	width = rw;
	height = rh;
}

Boolean Rectangle::Contains( const Mix::Point& p ) const
{
	if( ( x > p.x ) ||
		( y > p.y ) ||
		( GetRight() < p.x ) ||
		( GetBottom() < p.y ) )
	{
		return False;
	}

	return True;
}

Boolean Rectangle::Contains( const Mix::Rectangle& rect, Mix::Rectangle* pOverlapRect ) const
{
	if( ( x > rect.GetRight() ) ||
		( y > rect.GetBottom() ) ||
		( GetRight() < rect.x ) ||
		( GetBottom() < rect.y ) )
	{
		return False;
	}

	if( pOverlapRect != NULL )
	{
		pOverlapRect->x = max( x, rect.x );
		pOverlapRect->y = max( y, rect.y );
		pOverlapRect->SetRight( min( GetRight(), rect.GetRight() ) );
		pOverlapRect->SetBottom( min( GetBottom(), rect.GetBottom() ) );
	}

	return True;
}

void Rectangle::SetRight( Int32 right )
{
	width = right - x + 1;
}

Int32 Rectangle::GetRight( void ) const
{
	return x + width - 1;
}

void Rectangle::SetBottom( Int32 bottom )
{
	height = bottom - y + 1;
}

Int32 Rectangle::GetBottom( void ) const
{
	return y + height - 1;
}
