#include "Mix/Reference.h"

namespace Mix{

Reference::Reference( void ) :
m_Count( 1 )
{
}

Reference::Reference( Long32 count ) :
m_Count( count )
{
}

Reference::~Reference( void )
{
}

void Reference::AddRef( void )
{
	m_Count.Increment();
}

void Reference::Release( void )
{
	if( m_Count.Decrement() == 0 )
	{
		MIX_DELETE_THIS_T( Reference, this );
	}
}

Long32 Reference::GetRefCount( void )
{
	return m_Count.Get();
}

}