#pragma once

#include "Mix/Scene/IActorConstraint.h"

namespace Mix{ namespace Scene{ namespace Common{

	class ActorConstraint : public Mix::Scene::IActorConstraint
	{
	public:
		static ActorConstraint* CreateInstance( const wchar_t* pName );

	private:
		Mix::StringW m_Name;
		Mix::Matrix4x4 m_LocalMat;
		Mix::Matrix4x4 m_WorldMat;

	private:
		ActorConstraint( const wchar_t* pName );
		virtual ~ActorConstraint( void );

	public:
		void Update( const Mix::Matrix4x4& mat );

	public:
		virtual const wchar_t* GetName( void ) const;

		virtual void SetLocalMatrix( const Mix::Matrix4x4& mat );
		virtual const Mix::Matrix4x4& GetLocalMatrix( void ) const;

		virtual const Mix::Matrix4x4& GetWorldMatrix( void ) const;
	};

}}}
