#pragma once

#include "Mix/Reference.h"

namespace Mix{ namespace Scene{ namespace Common{

	class ActorRevision;
	class ActorKinematicCharacter;
	class ActorCollider;
	class ActorSensor;

	class ActorDynamicsCluster : public Mix::Reference
	{
	private:
		typedef Mix::STL::Vector<Mix::Memory::SECTION_SCENE, Mix::Scene::Common::ActorSensor*> SensorList;
		typedef Mix::STL::Map<Mix::Memory::SECTION_SCENE, Mix::StringW, ActorDynamicsCluster::SensorList> SensorListMap;

	protected:
		Mix::Matrix4x4* m_pParentWorldMat;
		Mix::Matrix4x4* m_pWorldMat;

		Mix::Scene::Common::ActorRevision* m_pRevision;

		Mix::Dynamics::IWorld* m_pWorld;

		Mix::Scene::DYNAMICS_COLLIDER_MODE m_ColliderMode;
		Mix::Scene::Common::ActorCollider* m_pCollider;

		Boolean m_bSensorEnabled;
		ActorDynamicsCluster::SensorListMap m_SensorListMap;
		ActorDynamicsCluster::SensorList m_SensorList;

	protected:
		ActorDynamicsCluster( void );
		virtual ~ActorDynamicsCluster( void );

		Boolean Clone( ActorDynamicsCluster* pCloneCluster );

	public:
		void SetCollider( Mix::Scene::Common::ActorCollider* pCollider );
		Mix::Scene::Common::ActorCollider* GetColliderPtr( void ) const;

		void AddSensor( Mix::Scene::Common::ActorSensor* pSensor );
		void FinishSensors( UIntT num );
		UInt32 GetSensorCount( void ) const;
		Mix::Scene::Common::ActorSensor* GetSensorPtr( UInt32 index ) const;

	protected:
		virtual void OnColliderStateChanged( Boolean state ) {}
		virtual void OnColliderModeChanged( Mix::Scene::DYNAMICS_COLLIDER_MODE mode ) {}
		virtual void OnSensorStateChanged( Boolean state ) {}

	public:
		//N
		virtual void SetLink( Mix::Scene::IRendererObject* pOwner, Mix::Matrix4x4* pParentWorldMat, Mix::Matrix4x4* pWorldMat );

		//RC_[
		Boolean IsColliderEnabled( void ) const;
		void SetColliderEnabled( Boolean state );
		Mix::Scene::DYNAMICS_COLLIDER_MODE GetColliderMode( void ) const;
		void SetColliderMode( Mix::Scene::DYNAMICS_COLLIDER_MODE mode );
		Mix::Matrix4x4 GetColliderMatrix( void ) const;

		//ZT[
		Boolean IsSensorEnabled( void ) const;
		void SetSensorEnabled( Boolean state );

		//Փ˂NX^[ǂ̊mF( RC_[ALl}eBbNLN^[ )
		virtual Boolean IsCollide( void ) const;
		//[hgXtH[NX^[ōXVĂ邩ǂ̊mF( 񊈓Ԃł True Ԃ܂ )
		virtual Boolean IsControl( void ) const;
		//Ԃǂ̊mF
		virtual Boolean IsActive( void ) const;

		//[h
		virtual void AttachToWorld( Mix::Dynamics::IWorld* pWorld, Mix::Dynamics::IObjectListener* pObjectListener );
		virtual void DetachFromWorld( Mix::Dynamics::IWorld* pWorld );

		//Zbg(  )
		virtual void Reset( void );
		virtual void ResetChild( const Mix::Matrix4x4& baseMat ); //̃ZbgĂяo

		//Abvf[g( [h̃V~[VÕ[hs̍XVɌĂ )
		virtual void Update( void );
		virtual Boolean NeedsUpdateChild( void ) const;
		virtual void UpdateChild( const Mix::Matrix4x4& baseMat ); // Update Ăяo

		//tbV( [h̃V~[VɌĂ )
		//Ԓl : [hgXtH[XVꍇ True Ԃ܂
		virtual Boolean Refresh( void );

		//j
		virtual void Dispose( void );

#ifdef _DEBUG
		virtual void Debug_Draw(	UInt32 flags,
									Mix::Graphics::Utility::IPerspectiveRenderer* pPerspectiveRenderer,
									Float32 axisScaling,
									Float32 jointFrameMinSize,
									Float32 jointLimitScaling );
#endif //_DEBUG
	};

}}}
