#include "Mix/Private/Scene/Common/ActorRevision.h"

namespace Mix{ namespace Scene{ namespace Common{

ActorRevision::ActorRevision( UInt32* pFlags, UInt32* pCounter, UInt32 mask, UInt32 clear, const UInt32* table )
{
	MIX_ASSERT( pFlags != NULL );
	MIX_ASSERT( pCounter != NULL );
	MIX_ASSERT( clear != 0 );
	MIX_ASSERT( table != NULL );

	m_pFlags = pFlags;
	m_pCounter = pCounter;
	m_Mask = mask;
	m_Clear = clear;

	for( UInt32 i = 0; i < ActorRevision::TYPE_MAX; i++ )
	{
		m_Table[i] = table[i];
	}
}

ActorRevision::~ActorRevision( void )
{
}

Boolean ActorRevision::IsControlWorldTransform( void ) const
{
	return ( ( *m_pFlags & m_Table[ActorRevision::CTRL_WORLD_MAT] ) != 0 );
}

Boolean ActorRevision::SetControlWorldTransform( void )
{
	if( MIX_TESTBIT( *m_pFlags, m_Mask ) == 0 )
	{
		//\Ȃ̂Ńrbg𗧂Ă邾ŁAJE^[͉񂳂Ȃ
		MIX_ASSERT( ( *m_pFlags & m_Table[ActorRevision::CTRL_WORLD_MAT] ) == 0 );
		*m_pFlags |= m_Table[ActorRevision::CTRL_WORLD_MAT];

		return True;
	}

	return False;
}

Boolean ActorRevision::IsWorldTransform( void ) const
{
	return ( ( *m_pFlags & m_Table[ActorRevision::WORLD_MAT] ) != 0 );
}

void ActorRevision::SetWorldTransform( void )
{
	MIX_ASSERT( ( *m_pFlags & m_Table[ActorRevision::CTRL_WORLD_MAT] ) != 0 );
	MIX_ASSERT( ( *m_pFlags & m_Table[ActorRevision::WORLD_MAT] ) == 0 );
	MIX_ASSERT( ( *m_pFlags & m_Table[ActorRevision::LOCAL_MAT] ) == 0 );

	*m_pFlags |= m_Table[ActorRevision::WORLD_MAT];
	*m_pCounter = *m_pCounter + 1;
}

Boolean ActorRevision::IsLocalTransform( void ) const
{
	return ( MIX_TESTBIT( *m_pFlags, m_Table[ActorRevision::LOCAL_MAT] ) != 0 );
}

Boolean ActorRevision::SetLocalTransform( void )
{
	if( MIX_TESTBIT( *m_pFlags, m_Mask ) == 0 )
	{
		*m_pFlags = *m_pFlags | m_Table[ActorRevision::LOCAL_MAT];
		*m_pCounter = *m_pCounter + 1;

		return True;
	}

	return False;
}

void ActorRevision::Clear( void )
{
	*m_pFlags = *m_pFlags & m_Clear;
}

}}}
