#include "Mix/Private/Scene/Common/Debug.h"

#ifdef _DEBUG

#include "Mix/Private/Dynamics/Utility.h"

namespace Mix{ namespace Scene{ namespace Common{ namespace Debug{

	static Mix::Vector4 DRAW_COLOR_TABLE[Mix::Scene::DDC_MAX] =
	{
		Mix::Vector4( 0.00f, 0.00f, 0.00f, 1.00f ), //_Ci~NX : gp
		Mix::Vector4( 0.00f, 0.00f, 0.00f, 1.00f ), //_Ci~NX : gp
		Mix::Vector4( 0.00f, 0.00f, 0.00f, 1.00f ), //_Ci~NX : gp
		Mix::Vector4( 0.00f, 0.00f, 0.00f, 1.00f ), //_Ci~NX : gp
		Mix::Vector4( 0.00f, 0.00f, 0.00f, 1.00f ), //_Ci~NX : gp
		Mix::Vector4( 0.00f, 0.00f, 0.00f, 1.00f ), //_Ci~NX : gp
		Mix::Vector4( 0.00f, 0.00f, 0.00f, 1.00f ), //_Ci~NX : gp
		Mix::Vector4( 0.00f, 0.00f, 0.00f, 1.00f ), //_Ci~NX : gp
		Mix::Vector4( 0.00f, 0.00f, 0.00f, 1.00f ), //_Ci~NX : gp

		Mix::Vector4( 1.00f, 0.72f, 0.30f, 0.80f ),	//DDC_BOUNDS
		Mix::Vector4( 1.00f, 1.00f, 1.00f, 0.80f ), //DDC_OCTREE_NODE_BOUNDS
		Mix::Vector4( 0.30f, 0.30f, 0.30f, 0.80f ), //DDC_OCTREE_OBJS_BOUNDS
		Mix::Vector4( 0.60f, 0.60f, 0.60f, 0.80f ),	//DDC_LIGHT_SHAPE
		Mix::Vector4( 0.10f, 0.80f, 0.20f, 0.80f ),	//DDC_PARTICLE_QUAD
		Mix::Vector4( 0.94f, 0.89f, 0.81f, 0.80f ),	//DDC_ACTORMODEL_SKELETAL
		Mix::Vector4( 0.50f, 0.00f, 0.50f, 0.80f ),	//DDC_SM_CLIP_BOOUNDS
		Mix::Vector4( 0.80f, 0.00f, 0.60f, 0.80f ), //DDC_SM_CAST_BOOUNDS

		Mix::Vector4( 0.00f, 0.00f, 0.00f, 0.50f ), //DDC_FILMIC_BG
		Mix::Vector4( 1.00f, 1.00f, 1.00f, 0.80f ), //DDC_FILMIC_MEMORY
		Mix::Vector4( 1.00f, 0.00f, 0.00f, 1.00f ), //DDC_FILMIC_CURVE

		Mix::Vector4( 1.00f, 1.00f, 0.00f, 0.50f ), //DDC_ABERRATION
	};

	Boolean IsDynDrawColorType( Mix::Scene::DEBUG_DRAW_COLOR_TYPE type )
	{
		if( ( Mix::Scene::DDC_DYNAMICS_FIRST > type ) ||
			( Mix::Scene::DDC_DYNAMICS_LAST < type ) )
		{
			return False;
		}

		return True;
	}

	Mix::Dynamics::DEBUG_DRAW_COLOR_TYPE ToDynDrawColorType( Mix::Scene::DEBUG_DRAW_COLOR_TYPE type )
	{
		MIX_ASSERT( ( type >= Mix::Scene::DDC_DYNAMICS_FIRST ) && ( type <= Mix::Scene::DDC_DYNAMICS_LAST ) );
		return static_cast<Mix::Dynamics::DEBUG_DRAW_COLOR_TYPE>( type - Mix::Scene::DDC_DYNAMICS_FIRST );
	}

	const Mix::Vector4& GetDrawColor( Mix::Scene::DEBUG_DRAW_COLOR_TYPE type )
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// _Ci~NX
		////////////////////////////////////////////////////////////////////////////////////////////////////

		if( Mix::Scene::Common::Debug::IsDynDrawColorType( type ) == True )
		{
			return Mix::Dynamics::Debug::GetColor( Mix::Scene::Common::Debug::ToDynDrawColorType( type ) );
		}

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// V[
		////////////////////////////////////////////////////////////////////////////////////////////////////

		return Mix::Scene::Common::Debug::DRAW_COLOR_TABLE[type];
	}

	void SetDrawColor( Mix::Scene::DEBUG_DRAW_COLOR_TYPE type, const Mix::Vector4& color )
	{
		if( Mix::Scene::Common::Debug::IsDynDrawColorType( type ) == True )
		{
			////////////////////////////////////////////////////////////////////////////////////////////////////
			// _Ci~NX
			////////////////////////////////////////////////////////////////////////////////////////////////////

			Mix::Dynamics::Debug::SetColor( Mix::Scene::Common::Debug::ToDynDrawColorType( type ), color );
		}
		else
		{
			////////////////////////////////////////////////////////////////////////////////////////////////////
			// V[
			////////////////////////////////////////////////////////////////////////////////////////////////////

			Mix::Scene::Common::Debug::DRAW_COLOR_TABLE[type] = color;
		}
	}

}}}}

#endif //_DEBUG