#include "Mix/Private/Scene/Common/EffectPackage.h"

#include "Mix/IO/IReader.h"
#include "Mix/Graphics/IVertexLayout.h"
#include "Mix/Graphics/IVertexShader.h"
#include "Mix/Graphics/IPixelShader.h"

namespace Mix{ namespace Scene{ namespace Common{

////////////////////////////////////////////////////////////////////////////////////////////////////
// EffectPackage : 萔
////////////////////////////////////////////////////////////////////////////////////////////////////

//}WbNio[
const UInt32 EffectPackage::FILE_MAGIC_NUMBER	= 0x5F50454D;

//o[W
const UInt32 EffectPackage::FILE_VERSION_OLD	= 0x01000000;
const UInt32 EffectPackage::FILE_VERSION		= 0x01010000;

//G[bZ[W
const wchar_t* EffectPackage::FAILED_CREATE              = L"GtFNgpbP[W̍쐬Ɏs";
const wchar_t* EffectPackage::FAILED_CREATE_MEP_IO_ERROR = L"ǂݍƂt@C̓GtFNgpbP[Wł͂܂";

//}eAGtFNgpbP[W̃t@Č
const wchar_t* EffectPackage::MEP_FILEEXT_TABLE[Mix::Graphics::SHADER_MODEL_MAX] =
{
	L"_3.mep",
	L"_4.mep",
	L"_5.mep",
};

////////////////////////////////////////////////////////////////////////////////////////////////////
// Manager::VERTEX_EFFECT
////////////////////////////////////////////////////////////////////////////////////////////////////

EffectPackage::VERTEX_EFFECT::VERTEX_EFFECT( void )
{
	pLayout = NULL;

	for( UInt32 i = 0; i < EffectPackage::VES_MAX; i++ )
	{
		pShader[i] = NULL;
	}
}

void EffectPackage::VERTEX_EFFECT::Dispose( void )
{
	MIX_RELEASE( pLayout );

	for( UInt32 i = 0; i < EffectPackage::VES_MAX; i++ )
	{
		MIX_RELEASE( pShader[i] );
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Manager::PIXEL_EFFECT
////////////////////////////////////////////////////////////////////////////////////////////////////

EffectPackage::PIXEL_EFFECT::PIXEL_EFFECT( void )
{
	for( UInt32 i = 0; i < EffectPackage::PES_MAX; i++ )
	{
		pShader[i] = NULL;
	}
}

void EffectPackage::PIXEL_EFFECT::Dispose( void )
{
	for( UInt32 i = 0; i < EffectPackage::PES_MAX; i++ )
	{
		MIX_RELEASE( pShader[i] );
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// EffectPackage : NX
////////////////////////////////////////////////////////////////////////////////////////////////////

Boolean EffectPackage::LoadFileHeader( const wchar_t* pFilePath, Mix::IO::IReader* pReader, EffectPackage::MEP_FILE_HEADER& fileHeader )
{
	MIX_ASSERT( pFilePath != NULL );
	MIX_ASSERT( pReader != NULL );

	UInt32 readSize = sizeof( EffectPackage::MEP_FILE_HEADER );

	if( pReader->Read( &fileHeader, readSize ) != readSize )
	{
		MIX_LOG_ERROR( L"%s : FilePath[%s]", EffectPackage::FAILED_CREATE_MEP_IO_ERROR, pFilePath );
		return False;
	}

	if( fileHeader.magicNumber != FILE_MAGIC_NUMBER )
	{
		MIX_LOG_ERROR( L"%s : FilePath[%s]", EffectPackage::FAILED_CREATE_MEP_IO_ERROR, pFilePath );
		return False;
	}

	MIX_LOG_INFO( L"FilePath[%s]", pFilePath );
	MIX_LOG_INFO( L"Version[0x%08x]", fileHeader.version );

	return True;
}

EffectPackage::EffectPackage( const wchar_t* pDirPath, const wchar_t* pName, const wchar_t* pFilePath )
{
	MIX_ASSERT( pDirPath != NULL );
	MIX_ASSERT( pName != NULL );
	MIX_ASSERT( pFilePath != NULL );

	m_DirPath = pDirPath;
	m_Name = pName;
	m_FilePath = pFilePath;
}

EffectPackage::~EffectPackage( void )
{
}

const wchar_t* EffectPackage::GetDirectoryPath( void ) const
{
	return m_DirPath.GetConstPtr();
}

const wchar_t* EffectPackage::GetName( void ) const
{
	return m_Name.GetConstPtr();
}

const wchar_t* EffectPackage::GetFilePath( void ) const
{
	return m_FilePath.GetConstPtr();
}

}}}
