#pragma once

#include "Mix/Scene/IEffectPackage.h"

namespace Mix{ namespace Scene{ namespace Common{

	class EffectPackage : public Mix::Scene::IEffectPackage
	{
	public:
		enum PUBLIC_VALUE
		{
			VES_MAX	= 3,
			PES_MAX	= 10,
		};

		//MEPt@Cwb_\
		struct MEP_FILE_HEADER
		{
			UInt32 magicNumber;
			UInt32 version;
		};

		//o[ebNXGtFNg\
		struct VERTEX_EFFECT
		{
			Mix::Graphics::IVertexLayout* pLayout;
			Mix::Graphics::IVertexShader* pShader[EffectPackage::VES_MAX];

			VERTEX_EFFECT( void );
			void Dispose( void );
		};

		//sNZGtFNg\
		struct PIXEL_EFFECT
		{
			Mix::Graphics::IPixelShader* pShader[EffectPackage::PES_MAX];

			PIXEL_EFFECT( void );
			void Dispose( void );
		};

	private:
		Mix::StringW m_DirPath;
		Mix::StringW m_Name;
		Mix::StringW m_FilePath;

	public:
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::Common::EffectPackage
		////////////////////////////////////////////////////////////////////////////////////////////////////

		static Boolean LoadFileHeader( const wchar_t* pFilePath, Mix::IO::IReader* pReader, MEP_FILE_HEADER& fileHeader );

		EffectPackage( const wchar_t* pDirPath, const wchar_t* pName, const wchar_t* pFilePath );
		virtual ~EffectPackage( void );

		virtual EffectPackage::VERTEX_EFFECT* GetVertexEffectPtr( UInt32 type, UInt32 opt ) = 0;
		virtual EffectPackage::PIXEL_EFFECT* GetPixelEffectPtr( UInt32 type, UInt32 opt ) = 0;

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::IEffectPackage
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual const wchar_t* GetDirectoryPath( void ) const;
		virtual const wchar_t* GetName( void ) const;
		virtual const wchar_t* GetFilePath( void ) const;

	public:
		static const UInt32 FILE_MAGIC_NUMBER;

		static const UInt32	FILE_VERSION_OLD;
		static const UInt32	FILE_VERSION;

		static const wchar_t* FAILED_CREATE;
		static const wchar_t* FAILED_CREATE_MEP_IO_ERROR;

		static const wchar_t* MEP_FILEEXT_TABLE[Mix::Graphics::SHADER_MODEL_MAX];
	};

}}}