#include "Mix/Private/Scene/Common/LightShaftsCaster.h"

#include "Mix/Graphics/ITexture.h"
#include "Mix/Private/Scene/Common/Camera.h"

namespace Mix{ namespace Scene{ namespace Common{

const wchar_t* LightShaftsCaster::FAILED_CREATE = L"CgVtgLX^[̍쐬Ɏs";

LightShaftsCaster* LightShaftsCaster::CreateInstance( void )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_SCENE, LightShaftsCaster );
}

LightShaftsCaster::LightShaftsCaster( void ) :
m_Pos( 0.0f, 1000.0f, 0.0f ),
m_bEnabled( True )
{
}

LightShaftsCaster::~LightShaftsCaster( void )
{
}

void LightShaftsCaster::Attach( void )
{
	RendererObject::SetRendering( True );
}

void LightShaftsCaster::Detach( void )
{
	RendererObject::SetRendering( False );
}

Boolean LightShaftsCaster::GetParam( Mix::Scene::Common::Camera* pCamera, LightShaftsCaster::PARAM& param )
{
	MIX_ASSERT( pCamera != NULL );

	Mix::Vector3 pos = pCamera->GetViewProjectionMatrix() * m_Pos;

	if( ( pos.z < 0.0f ) || ( pos.z > 1.0f ) )
	{
		return False;
	}

	Float32 invFarZ = MIX_FLOAT_RECIPROCAL( pCamera->GetFarZ() );

	param.pos.x = 1.0f - ( -pos.x * 0.5f + 0.5f );
	param.pos.y = 1.0f - ( +pos.y * 0.5f + 0.5f );
	param.EdotL = Mix::Vector3::Dot( pCamera->GetViewForward(), m_Pos.ToNormalize() );

	return True;
}

Boolean LightShaftsCaster::IsEnabled( void ) const
{
	return m_bEnabled;
}

void LightShaftsCaster::SetEnabled( Boolean state )
{
	m_bEnabled = state;
}

const Mix::Vector3& LightShaftsCaster::GetPosition( void ) const
{
	return m_Pos;
}

void LightShaftsCaster::SetPosition( const Mix::Vector3& pos )
{
	m_Pos = pos;
}

Mix::Scene::IRendererObject::TYPE LightShaftsCaster::GetType( void ) const
{
	return Mix::Scene::IRendererObject::LIGHT_SHAFTS_CASTER;
}

Boolean LightShaftsCaster::IsRendering( void ) const
{
	return RendererObject::IsRendering();
}

}}}
