#pragma once

#include "Mix/Scene/IMotionState.h"

namespace Mix{ namespace Scene{ namespace Common{

	class MotionController;

	class MotionState : public Mix::Scene::IMotionState
	{
	public:
		static MotionState* CreateInstance( MotionController* pController, const Mix::Scene::MOTION_HANDLE& handle );

	private:
		MotionController* m_pController;
		Mix::Scene::MOTION_HANDLE m_Handle;

		Float32 m_Speed;
		Float32 m_BlendRatio;
		Float32 m_Frame;
		UInt32 m_LoopCount;
		Float32 m_TransitionRatio;

	private:
		MotionState( MotionController* pController, const Mix::Scene::MOTION_HANDLE& handle );
		virtual ~MotionState( void );

	public:
		void SetFrame( Float32 frame );
		void SetLoopCount( UInt32 loopCount );
		void SetTransitionRatio( Float32 ratio );

		void Dispose( void );

	public:
		virtual void SetSpeed( Float32 speed );
		virtual Float32 GetSpeed( void ) const;

		virtual void SetBlendRatio( Float32 blendRatio );
		virtual Float32 GetBlendRatio( void ) const;

		virtual Float32 GetFrame( void ) const;

		virtual UInt32 GetLoopCount( void ) const;

		virtual UInt32 GetCondition( void ) const;

		virtual Float32 GetTransitionRatio( void ) const;
	};

}}}
