#pragma once

#include <vector>

#include "Mix/Reference.h"
#include "Mix/Private/Container.h"
#include "Mix/Private/Scene/Common/MotionTypes.h"

namespace Mix{ namespace File{
	class IReader;
}}

namespace Mix{ namespace Scene{ namespace Common{

	class RootMotionCurve : public Mix::Reference
	{
	private:
		struct MOT_CURV_DESC
		{
			UInt32 rotationKeyNum;
			UInt32 translationKeyNum;
		};

	private:
		Mix::Scene::Common::MotionQuaternionKeyList m_RotationKeyList;
		Mix::Scene::Common::MotionVectorKeyList m_TranslationKeyList;

	public:
		static RootMotionCurve* CreateInstance( void );
		static RootMotionCurve* CreateInstance( Mix::IO::IReader* pReader, const wchar_t* pNameLabel, const wchar_t* pName );

	private:
		RootMotionCurve( void );
		virtual ~RootMotionCurve( void );

		Mix::Quaternion GetRotation( float time );
		Mix::Vector3 GetTranslation( float time );

		Mix::Quaternion GetRotation( float preFrame, float nextFrame );
		Mix::Vector3 GetTranslation( float preFrame, float nextFrame );

	public:
		Boolean IsAvailable( void ) const;

		void Execute(	Float32 blendRatio,
						Float32 preFrame,
						Float32 frame,
						Mix::ContainerT<Mix::Scene::Common::MOTION_ROOT_BLEND, Mix::Memory::SECTION_SCENE>& container );

	private:
		static const wchar_t* FAILED_CREATE;
	};

}}}
