#pragma once

#include "Mix/Geometry.h"
#include "Mix/Scene/ISpotLight.h"
#include "Mix/Private/Scene/Common/OctreeObject.h"
#include "Mix/Private/Scene/Common/RendererObject.h"

namespace Mix{ namespace Scene{ namespace Common{

	class SpotLight : public Mix::Scene::ISpotLight, public Mix::Scene::Common::RendererObject
	{
	public:
		struct PARAM
		{
			Mix::Vector3 pos;
			Mix::Vector3 dir;
			Mix::Vector3 atten;
			Mix::Vector4 color;

			Float32 range;
			Float32 innerCos;
			Float32 outerCos;
			Float32 exp;
		};

	public:
		static SpotLight* CreateInstance( void );

	private:
		Boolean m_bEnabled;
		SpotLight::PARAM m_Param;
		Float32 m_InnerAngle;
		Float32 m_OuterAngle;
		Mix::Geometry::Sphere m_Bounds;
		Mix::Scene::Common::LocalLightObject* m_pOctObj;

	private:
		SpotLight( void );
		virtual ~SpotLight( void );

		void UpdateBounds( void );

	public:
		void Attach( Mix::Scene::Common::LocalLightObject* pOctObj );
		void Detach( void );

		const SpotLight::PARAM& GetParam( void ) const;

#ifdef _DEBUG
		void Debug_Draw( Mix::Graphics::Utility::IPerspectiveRenderer* pPerspectiveRenderer, UInt32 flags );
#endif //_DEBUG

	public:
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::ISpotLight
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual const Mix::Vector3& GetDirection( void ) const;
		virtual void SetDirection( const Mix::Vector3& dir );

		virtual Float32 GetRange( void ) const;
		virtual void SetRange( Float32 range );

		virtual Float32 GetConeInnerAngle( void ) const;
		virtual Float32 GetConeOuterAngle( void ) const;
		virtual void SetCone( Float32 innerAngle, Float32 outerAngle );

		virtual Float32 GetExponent( void ) const;
		virtual void SetExponent( Float32 exp );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::ILocalLight
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual const Mix::Vector4& GetColor( void ) const;
		virtual void SetColor( const Mix::Vector4& color );

		virtual Float32 GetLinearAttenuation( void ) const;
		virtual Float32 GetQuadraticAttenuation( void ) const;
		virtual Float32 GetExponentAttenuation( void ) const;
		virtual void SetAttenuation( Float32 l, Float32 q, Float32 e );

		virtual const Mix::Vector3& GetPosition( void ) const;
		virtual void SetPosition( const Mix::Vector3& pos );

		virtual void Refresh( void );

		virtual const Mix::Geometry::Sphere& GetBounds() const;

		virtual Boolean IsIllegal( void ) const;

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::ILight
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Boolean IsEnabled( void ) const;
		virtual void SetEnabled( Boolean state );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::IRendererObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Mix::Scene::IRendererObject::TYPE GetType( void ) const;
		virtual Boolean IsRendering( void ) const;

	public:
		static const wchar_t* FAILED_CREATE;
	};

}}}
