#pragma once

#include "Mix/Geometry/AABB.h"

namespace Mix{ namespace Scene{ namespace Common{

	class EffectPackage;
	class TerrainMesh;
	class TerrainModel;

	class TerrainLoader
	{
	private:
		enum MTM_VALUE
		{
			MTM_MAGICNUMBER		= 0x464D544D,	//}WbNio[

			MTM_VERSION_1_0_0_0	= 0x01000000,			//o[W 1.0.0.0
			MTM_VERSION_CURRENT	= MTM_VERSION_1_0_0_0,	//݂̃o[W
		};

		struct MTM_FILE_HEADER_1_0_0_0
		{
			UInt32 magicNumber;
			UInt32 version;
		};

		struct MTM_DATA_HEADER_1_0_0_0
		{
			UInt32 materialNum;
			UInt32 meshNum;
			UInt32 nodeNum;

			UInt32 collShapeSize;
			UInt32 collPolygonNum;
			UInt32 collMaterialNum;
		};

		struct MTM_NODE_1_0_0_0
		{
			Float32 aabb[6];
			Int32 mesh;
			Int32 parent;
			Int32 childCount;
			Int32 reserve;
		};

		typedef Mix::STL::Vector<Mix::Memory::SECTION_SCENE, Mix::Scene::Common::TerrainMesh*> MeshList;
		typedef Mix::STL::Vector<Mix::Memory::SECTION_SCENE, TerrainLoader::MTM_NODE_1_0_0_0> NodeList;

	private:
		Mix::Dynamics::IManager* m_pDynamicsManager;
		Mix::Graphics::IDevice* m_pGraphicsDevice;

		TerrainLoader::MeshList m_MeshList;
		TerrainLoader::NodeList m_NodeList;

	private:
		Boolean Create( Mix::Scene::Common::EffectPackage* pEffectPackage, Mix::IO::IReader* pReader, Mix::Scene::Common::TerrainModel* pModel );

	public:
		MIX_DECLARE_ALLOCATOR();

		TerrainLoader( void );
		virtual ~TerrainLoader( void );

		Mix::Scene::ITerrainModel* Create( Mix::Scene::Common::EffectPackage* pEffectPackage, Mix::IO::IReader* pReader );

	public:
		static const wchar_t* FAILED_CREATE;
	};

}}}
