#pragma once

#include "Mix/Geometry/AABB.h"

namespace Mix{ namespace Scene{ namespace Common{

	class TerrainMesh;

	class TerrainNode
	{
	private:
		typedef Mix::STL::Vector<Mix::Memory::SECTION_SCENE, TerrainNode*> ChildList;

	private:
		Mix::Geometry::AABB m_DefaultBounds;
		Mix::Geometry::AABB m_Bounds;

		Mix::Scene::Common::TerrainMesh* m_pMesh;

		IntT m_ParentIndex;
		TerrainNode::ChildList m_ChildList;

	public:
		MIX_DECLARE_ALLOCATOR();

		TerrainNode( void );
		~TerrainNode( void );

		void SetBounds( const Float32* aabb );
		void SetBounds( const Mix::Geometry::AABB& aabb );
		void UpdateBounds( const Mix::Vector3& worldPos );
		const Mix::Geometry::AABB& GetBounds( void ) const;
		const Mix::Geometry::AABB& GetDefaultBounds( void ) const;

		void SetMesh( Mix::Scene::Common::TerrainMesh* pMesh );
		Mix::Scene::Common::TerrainMesh* GetMeshPtr( void ) const;

		void SetParent( IntT parentIndex, TerrainNode* pParent );
		IntT GetParentIndex( void ) const;

		void ReserveChildList( UIntT count );
		UIntT GetChildCount( void ) const;
		TerrainNode* GetChildPtr( UIntT index ) const;
	};

}}}
