#pragma once

#include "Mix/Geometry/AABB.h"
#include "Mix/Geometry/Sphere.h"
#include "Mix/Private/Scene/Common/RendererTypes.h"

namespace Mix{ namespace Scene{ namespace Common{

	// EBWFbg : el
	static const UInt32 WIDGET_POS_SIZE = 12;
	static const UInt32 WIDGET_COLOR_SIZE = sizeof( Float32[4] );
	static const UInt32 WIDGET_NORMAL_SIZE = sizeof( Float32[3] );
	static const UInt32 WIDGET_TEXTURE_SIZE = sizeof( Float32[2] );
	static const UInt32 WIDGET_VERTEX_STRIDE = 48; // WIDGET_POS_SIZE + WIDGET_COLOR_SIZE + WIDGET_NORMAL_SIZE + WIDGET_TEXTURE_SIZE
	static const UInt32 WIDGET_QUAD_STRIDE = 288; // WIDGET_VERTEX_STRIDE * 6
	static const UInt32 WIDGET_QUAD_POINT_NUM = 6;

	// EBWFbg : J[A@Aڐ
	static const UInt32 WIDGET_DATA_OFFSET = 12;
	static const UInt32 WIDGET_DATA_SIZE = 28; // WIDGET_COLOR_SIZE + WIDGET_NORMAL_SIZE

	// EBWFbg : Nbh\
	struct WIDGET_QUAD
	{
		/*
			SW
		*/

		Mix::Vector3 pos;

		/*
			_W
			  localPoints  r{[h̍Ɨp̂ IParticleProcessor::FACE::localPoints ̃|C^ɂȂ
		*/

		const Mix::Vector3* localPoints;
		Mix::Vector3 points[4];

		/*
			f[^
			  color normal ͒_obt@ɈꊇŃRs[邽߁Adata ̊eʒũAhXɂȂ
			  ܂ normal ̓r{[hł͎gpȂ
		*/

		UInt8 data[WIDGET_DATA_SIZE];
		UInt32 dataSize;

		Mix::Vector4& color;
		Mix::Vector3& normal;

		/*
			eNX`W
			  texCoords ͕ϊƂȂ߁AIParticleRenderer::FACE::texCoords ̃|C^ ɂȂ
			  texWriteOffset ͏̃f[^̃TCYϒ̂߁A1_̏݃ItZbgɂȂ( W( sizeof( MixVector3 ) ) + dataSize )
		*/

		const Mix::Vector2* texCoords;
		UInt32 texWriteOffset;

		WIDGET_QUAD( void ) :
		color( *reinterpret_cast<Mix::Vector4*>( &data[0] ) ),
		normal( *reinterpret_cast<Mix::Vector3*>( &data[16] ) )
		{
		}
	};

	// EBWFbg : TuZbg\
	struct WIDGET_SUBSET
	{
		// _[Őݒ肳܂ //

		UInt32 refractClass;

		Float32 minZ;
		Float32 maxZ;

		UInt32 localLightID;
		UInt32 localLightCount;

		//////////////////////////////

		UInt32 priority;

		UInt32 quadCount;
		Mix::Scene::Common::WIDGET_QUAD** quads;

		Mix::Scene::IMaterial* pMaterial;

		//////////////////////////////

		virtual void Update( const Mix::Vector3& normal, Float32 d ) = 0;
		virtual void AppendBounds( Mix::Geometry::AABB& out ) = 0;
	};

	// EBWFbg : AABBTuZbg
	struct WIDGET_AABB_SUBSET : public WIDGET_SUBSET
	{
		Mix::Geometry::AABB bounds;

		virtual void Update( const Mix::Vector3& normal, Float32 d )
		{
			const Mix::Vector3* pPoint = &( bounds.points[0] );
			const Mix::Vector3* pPointEnd = pPoint + 8;
			Float32 z;

			//ŏAő[x

			minZ = +MIX_FLOAT_MAX;
			maxZ = -MIX_FLOAT_MAX;

			while( pPoint != pPointEnd )
			{
				z = ( pPoint->x * normal.x ) + ( pPoint->y * normal.y ) + ( pPoint->z * normal.z ) + d;

				if( minZ > z ) { minZ = z; }
				if( maxZ < z ) { maxZ = z; }

				pPoint++;
			}

			// [JCg̃NA

			localLightID = 0xFFFFFFFF;
			localLightCount = 0;
		}

		virtual void AppendBounds( Mix::Geometry::AABB& out )
		{
			out += bounds;
		}
	};

	// EBWFbg : SphereTuZbg
	struct WIDGET_SPHERE_SUBSET : public WIDGET_SUBSET
	{
		Mix::Geometry::Sphere bounds;

		virtual void Update( const Mix::Vector3& normal, Float32 d )
		{
			const Mix::Vector3& center = bounds.center;
			Float32 radius = bounds.radius;

			Float32 z = ( center.x * normal.x ) + ( center.y * normal.y ) + ( center.z * normal.z ) + d;

			//ŏAő[x

			minZ = z - radius;
			maxZ = z + radius;

			// [JCg̃NA

			localLightID = 0xFFFFFFFF;
			localLightCount = 0;
		}

		virtual void AppendBounds( Mix::Geometry::AABB& out )
		{
			out += bounds;
		}
	};

	// EBWFbg : IuWFNg
	//
	// [JCgƂ̔pɎgpĂ܂
	struct WIDGET_OBJECT
	{
		Float32 minZ;
		Float32 maxZ;

		Mix::Geometry::AABB bounds;

		UInt32 subsetStart;
		UInt32 subsetNum;
	};

}}}
