#include "Mix/Private/Scene/Standard/DX10/EffectPackage.h"
#include "Mix/Private/Scene/Standard/DX10/EffectResource.h"

namespace Mix{ namespace Scene{ namespace Standard{ namespace DX10{

EffectPackage* EffectPackage::CreateInstance( const wchar_t* pDirPath, const wchar_t* pName, const wchar_t* pFilePath )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_SCENE, EffectPackage, pDirPath, pName, pFilePath );
}

EffectPackage::EffectPackage( const wchar_t* pDirPath, const wchar_t* pName, const wchar_t* pFilePath ) :
	Mix::Scene::Standard::Common::EffectPackage( pDirPath, pName, pFilePath )
{
}

EffectPackage::~EffectPackage( void )
{
}

void EffectPackage::GetShaderBinary( EffectPackage::SHADER_TYPES type, EffectPackage::SHADER_BINARY& out )
{
	switch( type )
	{
	// Misc //

	case EffectPackage::SHADER_SAMPLING_VS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Sampling(DX10_4)" );
		out.pData = &( MEP_VS_SAMPLING_4[0] );
		out.dataSize = sizeof( MEP_VS_SAMPLING_4 );
		break;
	case EffectPackage::SHADER_SAMPLING_COPY_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SamplingCopy(DX10_4)" );
		out.pData = &( MEP_PS_SAMPLING_COPY_4[0] );
		out.dataSize = sizeof( MEP_PS_SAMPLING_COPY_4 );
		break;
	case EffectPackage::SHADER_SAMPLING_DOWN2X_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SamplingDown2x(DX10_4)" );
		out.pData = &( MEP_PS_SAMPLING_DOWN2X_4[0] );
		out.dataSize = sizeof( MEP_PS_SAMPLING_DOWN2X_4 );
		break;
	case EffectPackage::SHADER_SAMPLING_DOWN4X_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SamplingDown4x(DX10_4)" );
		out.pData = &( MEP_PS_SAMPLING_DOWN4X_4[0] );
		out.dataSize = sizeof( MEP_PS_SAMPLING_DOWN4X_4 );
		break;

	case EffectPackage::SHADER_BLUR3X_X_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Blur3x_X(DX10_4)" );
		out.pData = &( MEP_PS_BLUR3X_X_4[0] );
		out.dataSize = sizeof( MEP_PS_BLUR3X_X_4 );
		break;
	case EffectPackage::SHADER_BLUR3X_Y_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Blur3x_Y(DX10_4)" );
		out.pData = &( MEP_PS_BLUR3X_Y_4[0] );
		out.dataSize = sizeof( MEP_PS_BLUR3X_Y_4 );
		break;

	case EffectPackage::SHADER_BLUR5X_X_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Blur5x_X(DX10_4)" );
		out.pData = &( MEP_PS_BLUR5X_X_4[0] );
		out.dataSize = sizeof( MEP_PS_BLUR5X_X_4 );
		break;
	case EffectPackage::SHADER_BLUR5X_Y_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Blur5x_Y(DX10_4)" );
		out.pData = &( MEP_PS_BLUR5X_Y_4[0] );
		out.dataSize = sizeof( MEP_PS_BLUR5X_Y_4 );
		break;

	case EffectPackage::SHADER_GAUSSIAN_BLUR_X_VS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"GaussianBlur_X(DX10_4)" );
		out.pData = &( MEP_VS_GAUSSIAN_BLUR_X_4[0] );
		out.dataSize = sizeof( MEP_VS_GAUSSIAN_BLUR_X_4 );
		break;
	case EffectPackage::SHADER_GAUSSIAN_BLUR_X_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"GaussianBlur_X(DX10_4)" );
		out.pData = &( MEP_PS_GAUSSIAN_BLUR_X_4[0] );
		out.dataSize = sizeof( MEP_PS_GAUSSIAN_BLUR_X_4 );
		break;
	case EffectPackage::SHADER_GAUSSIAN_BLUR_Y_VS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"GaussianBlur_Y(DX10_4)" );
		out.pData = &( MEP_VS_GAUSSIAN_BLUR_Y_4[0] );
		out.dataSize = sizeof( MEP_VS_GAUSSIAN_BLUR_Y_4 );
		break;
	case EffectPackage::SHADER_GAUSSIAN_BLUR_Y_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"GaussianBlur_Y(DX10_4)" );
		out.pData = &( MEP_PS_GAUSSIAN_BLUR_Y_4[0] );
		out.dataSize = sizeof( MEP_PS_GAUSSIAN_BLUR_Y_4 );
		break;

	case EffectPackage::SHADER_GAUSSIAN_BLUR_EX_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"GaussianBlurEx(DX10_4)" );
		out.pData = &( MEP_PS_GAUSSIAN_BLUR_EX_4[0] );
		out.dataSize = sizeof( MEP_PS_GAUSSIAN_BLUR_EX_4 );
		break;

	case EffectPackage::SHADER_BP____PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"BrightPass__(DX10_4)" );
		out.pData = &( MEP_PS_BRIGHTPASS____4[0] );
		out.dataSize = sizeof( MEP_PS_BRIGHTPASS____4 );
		break;
	case EffectPackage::SHADER_BP_L__PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"BrightPassL_(DX10_4)" );
		out.pData = &( MEP_PS_BRIGHTPASS_L__4[0] );
		out.dataSize = sizeof( MEP_PS_BRIGHTPASS_L__4 );
		break;
	case EffectPackage::SHADER_BP_LA_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"BrightPassLA(DX10_4)" );
		out.pData = &( MEP_PS_BRIGHTPASS_LA_4[0] );
		out.dataSize = sizeof( MEP_PS_BRIGHTPASS_LA_4 );
		break;

	// SkyDome //

	case EffectPackage::SHADER_SKYDOME_DEFAULT_VS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default ---- (DX10_4)" );
		out.pData = &( MEP_VS_SKYDOME_DEFAULT_4[0] );
		out.dataSize = sizeof( MEP_VS_SKYDOME_DEFAULT_4 );
		break;
	case EffectPackage::SHADER_SKYDOME_DEFAULT______PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default ---- (DX10_4)" );
		out.pData = &( MEP_PS_SKYDOME_DEFAULT______4[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_DEFAULT______4 );
		break;
	case EffectPackage::SHADER_SKYDOME_DEFAULT__C___PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default -C--- (DX10_4)" );
		out.pData = &( MEP_PS_SKYDOME_DEFAULT__C___4[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_DEFAULT__C___4 );
		break;
	case EffectPackage::SHADER_SKYDOME_DEFAULT__C2__PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default -C2- (DX10_4)" );
		out.pData = &( MEP_PS_SKYDOME_DEFAULT__C2__4[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_DEFAULT__C2__4 );
		break;
	case EffectPackage::SHADER_SKYDOME_DEFAULT_B____PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default B--- (DX10_4)" );
		out.pData = &( MEP_PS_SKYDOME_DEFAULT_B____4[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_DEFAULT_B____4 );
		break;
	case EffectPackage::SHADER_SKYDOME_DEFAULT_BC___PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default BC-- (DX10_4)" );
		out.pData = &( MEP_PS_SKYDOME_DEFAULT_BC___4[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_DEFAULT_BC___4 );
		break;
	case EffectPackage::SHADER_SKYDOME_DEFAULT_BC2__PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default BC2- (DX10_4)" );
		out.pData = &( MEP_PS_SKYDOME_DEFAULT_BC2__4[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_DEFAULT_BC2__4 );
		break;

	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE_VS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere ---- (DX10_4)" );
		out.pData = &( MEP_VS_SKYDOME_ATMOSPHERE_4[0] );
		out.dataSize = sizeof( MEP_VS_SKYDOME_ATMOSPHERE_4 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE______PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere ---- (DX10_4)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE______4[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE______4 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE__C___PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere -C--- (DX10_4)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE__C___4[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE__C___4 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE__C_L_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere -C--L (DX10_4)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE__C_L_4[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE__C_L_4 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE__C2__PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere -C2- (DX10_4)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE__C2__4[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE__C2__4 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE__C2L_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere -C2L (DX10_4)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE__C2L_4[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE__C2L_4 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE_B____PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere B--- (DX10_4)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE_B____4[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE_B____4 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE_BC___PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere BC-- (DX10_4)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE_BC___4[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE_BC___4 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE_BC_L_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere BC-L (DX10_4)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE_BC_L_4[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE_BC_L_4 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE_BC2__PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere BC2- (DX10_4)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE_BC2__4[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE_BC2__4 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE_BC2L_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere BC2L (DX10_4)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE_BC2L_4[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE_BC2L_4 );
		break;

	case EffectPackage::SHADER_SKYDOME_PANORAMA_VS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Panorama -- (DX10_4)" );
		out.pData = &( MEP_VS_SKYDOME_PANORAMA_4[0] );
		out.dataSize = sizeof( MEP_VS_SKYDOME_PANORAMA_4 );
		break;
	case EffectPackage::SHADER_SKYDOME_PANORAMA_FA_VS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Panorama FA (DX10_4)" );
		out.pData = &( MEP_VS_SKYDOME_PANORAMA_FA_4[0] );
		out.dataSize = sizeof( MEP_VS_SKYDOME_PANORAMA_FA_4 );
		break;
	case EffectPackage::SHADER_SKYDOME_PANORAMA_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Panorama -- (DX10_4)" );
		out.pData = &( MEP_PS_SKYDOME_PANORAMA_4[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_PANORAMA_4 );
		break;
	case EffectPackage::SHADER_SKYDOME_PANORAMA_FD_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Panorama FD (DX10_4)" );
		out.pData = &( MEP_PS_SKYDOME_PANORAMA_FD_4[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_PANORAMA_FD_4 );
		break;
	case EffectPackage::SHADER_SKYDOME_PANORAMA_FA_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Panorama FA (DX10_4)" );
		out.pData = &( MEP_PS_SKYDOME_PANORAMA_FA_4[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_PANORAMA_FA_4 );
		break;

	// PostEffect //

	case EffectPackage::SHADER_SSAO_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SSAO(DX10_4)" );
		out.pData = &( MEP_PS_SSAO_4[0] );
		out.dataSize = sizeof( MEP_PS_SSAO_4 );
		break;
	case EffectPackage::SHADER_SSAO_TEX_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SSAO_Tex(DX10_4)" );
		out.pData = &( MEP_PS_SSAO_TEX_4[0] );
		out.dataSize = sizeof( MEP_PS_SSAO_TEX_4 );
		break;

	case EffectPackage::SHADER_SM_FINISH____PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SM_Finish -- (DX10_4)" );
		out.pData = &( MEP_PS_SM_FINISH____4[0] );
		out.dataSize = sizeof( MEP_PS_SM_FINISH____4 );
		break;
	case EffectPackage::SHADER_SM_FINISH__B_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SM_Finish -B (DX10_4)" );
		out.pData = &( MEP_PS_SM_FINISH__B_4[0] );
		out.dataSize = sizeof( MEP_PS_SM_FINISH__B_4 );
		break;
	case EffectPackage::SHADER_SM_FINISH_R__PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SM_Finish R- (DX10_4)" );
		out.pData = &( MEP_PS_SM_FINISH_R__4[0] );
		out.dataSize = sizeof( MEP_PS_SM_FINISH_R__4 );
		break;
	case EffectPackage::SHADER_SM_FINISH_RB_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SM_Finish RB (DX10_4)" );
		out.pData = &( MEP_PS_SM_FINISH_RB_4[0] );
		out.dataSize = sizeof( MEP_PS_SM_FINISH_RB_4 );
		break;

	case EffectPackage::SHADER_UNDER_WATER_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"UnderWater(DX10_4)" );
		out.pData = &( MEP_PS_UNDER_WATER_4[0] );
		out.dataSize = sizeof( MEP_PS_UNDER_WATER_4 );
		break;

	case EffectPackage::SHADER_LUM_TRANSFORM_INITAL_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LumTransform_Inital(DX10_4)" );
		out.pData = &( MEP_PS_LUM_TRANSFORM_INITAL_4[0] );
		out.dataSize = sizeof( MEP_PS_LUM_TRANSFORM_INITAL_4 );
		break;
	case EffectPackage::SHADER_LUM_TRANSFORM_ITERATE_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LumTransform_Iterate(DX10_4)" );
		out.pData = &( MEP_PS_LUM_TRANSFORM_ITERATE_4[0] );
		out.dataSize = sizeof( MEP_PS_LUM_TRANSFORM_ITERATE_4 );
		break;
	case EffectPackage::SHADER_LUM_TRANSFORM_FINAL_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LumTransform_Final(DX10_4)" );
		out.pData = &( MEP_PS_LUM_TRANSFORM_FINAL_4[0] );
		out.dataSize = sizeof( MEP_PS_LUM_TRANSFORM_FINAL_4 );
		break;
	case EffectPackage::SHADER_LUM_ADAPTED_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LumAdapted(DX10_4)" );
		out.pData = &( MEP_PS_LUM_ADAPTED_4[0] );
		out.dataSize = sizeof( MEP_PS_LUM_ADAPTED_4 );
		break;
	case EffectPackage::SHADER_LUM_OPERATOR___B_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LumOperator__B(DX10_4)" );
		out.pData = &( MEP_PS_LUM_OPERATOR___B_4[0] );
		out.dataSize = sizeof( MEP_PS_LUM_OPERATOR___B_4 );
		break;
	case EffectPackage::SHADER_LUM_OPERATOR_T___PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LumOperatorT__(DX10_4)" );
		out.pData = &( MEP_PS_LUM_OPERATOR_T___4[0] );
		out.dataSize = sizeof( MEP_PS_LUM_OPERATOR_T___4 );
		break;
	case EffectPackage::SHADER_LUM_OPERATOR_T_B_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LumOperatorT_B(DX10_4)" );
		out.pData = &( MEP_PS_LUM_OPERATOR_T_B_4[0] );
		out.dataSize = sizeof( MEP_PS_LUM_OPERATOR_T_B_4 );
		break;
	case EffectPackage::SHADER_LUM_OPERATOR_TA__PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LumOperatorTA_(DX10_4)" );
		out.pData = &( MEP_PS_LUM_OPERATOR_TA__4[0] );
		out.dataSize = sizeof( MEP_PS_LUM_OPERATOR_TA__4 );
		break;
	case EffectPackage::SHADER_LUM_OPERATOR_TAB_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LumOperatorTAB(DX10_4)" );
		out.pData = &( MEP_PS_LUM_OPERATOR_TAB_4[0] );
		out.dataSize = sizeof( MEP_PS_LUM_OPERATOR_TAB_4 );
		break;

	case EffectPackage::SHADER_LS_INIT___PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LightShaftsInit_(DX10_4)" );
		out.pData = &( MEP_PS_LS_INIT___4[0] );
		out.dataSize = sizeof( MEP_PS_LS_INIT___4 );
		break;
	case EffectPackage::SHADER_LS_INIT_A_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LightShaftsInitA(DX10_4)" );
		out.pData = &( MEP_PS_LS_INIT_A_4[0] );
		out.dataSize = sizeof( MEP_PS_LS_INIT_A_4 );
		break;
	case EffectPackage::SHADER_LS_BLUR_L_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LightShaftsBlur_Low(DX10_4)" );
		out.pData = &( MEP_PS_LS_BLUR_L_4[0] );
		out.dataSize = sizeof( MEP_PS_LS_BLUR_L_4 );
		break;
	case EffectPackage::SHADER_LS_BLUR_M_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LightShaftsBlur_Middle(DX10_4)" );
		out.pData = &( MEP_PS_LS_BLUR_M_4[0] );
		out.dataSize = sizeof( MEP_PS_LS_BLUR_M_4 );
		break;
	case EffectPackage::SHADER_LS_BLUR_H_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LightShaftsBlur_High(DX10_4)" );
		out.pData = &( MEP_PS_LS_BLUR_H_4[0] );
		out.dataSize = sizeof( MEP_PS_LS_BLUR_H_4 );
		break;

	case EffectPackage::SHADER_LF_IMAGE____PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensFlare_Image___(DX10_4)" );
		out.pData = &( MEP_PS_LF_IMAGE____4[0] );
		out.dataSize = sizeof( MEP_PS_LF_IMAGE____4 );
		break;
	case EffectPackage::SHADER_LF_IMAGE__H_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensFlare_Image_H(DX10_4)" );
		out.pData = &( MEP_PS_LF_IMAGE__H_4[0] );
		out.dataSize = sizeof( MEP_PS_LF_IMAGE__H_4 );
		break;
	case EffectPackage::SHADER_LF_IMAGE_G__PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensFlare_Image_G_(DX10_4)" );
		out.pData = &( MEP_PS_LF_IMAGE_G__4[0] );
		out.dataSize = sizeof( MEP_PS_LF_IMAGE_G__4 );
		break;
	case EffectPackage::SHADER_LF_IMAGE_GH_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensFlare_ImageGH(DX10_4)" );
		out.pData = &( MEP_PS_LF_IMAGE_GH_4[0] );
		out.dataSize = sizeof( MEP_PS_LF_IMAGE_GH_4 );
		break;
	case EffectPackage::SHADER_LF_MODIFY____PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensFlare_Modify__(DX10_4)" );
		out.pData = &( MEP_PS_LF_MODIFY____4[0] );
		out.dataSize = sizeof( MEP_PS_LF_MODIFY____4 );
		break;
	case EffectPackage::SHADER_LF_MODIFY_D__PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensFlare_ModifyD_(DX10_4)" );
		out.pData = &( MEP_PS_LF_MODIFY_D__4[0] );
		out.dataSize = sizeof( MEP_PS_LF_MODIFY_D__4 );
		break;
	case EffectPackage::SHADER_LF_MODIFY__B_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensFlare_Modify_B(DX10_4)" );
		out.pData = &( MEP_PS_LF_MODIFY__B_4[0] );
		out.dataSize = sizeof( MEP_PS_LF_MODIFY__B_4 );
		break;
	case EffectPackage::SHADER_LF_MODIFY_DB_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensFlare_ModifyDB(DX10_4)" );
		out.pData = &( MEP_PS_LF_MODIFY_DB_4[0] );
		out.dataSize = sizeof( MEP_PS_LF_MODIFY_DB_4 );
		break;

	case EffectPackage::SHADER_FI_HEJL_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"FilmicHejl(DX10_4)" );
		out.pData = &( MEP_PS_FILMIC_HEJL_4[0] );
		out.dataSize = sizeof( MEP_PS_FILMIC_HEJL_4 );
		break;
	case EffectPackage::SHADER_FI_HABLE_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"FilmicHable(DX10_4)" );
		out.pData = &( MEP_PS_FILMIC_HABLE_4[0] );
		out.dataSize = sizeof( MEP_PS_FILMIC_HABLE_4 );
		break;

	case EffectPackage::SHADER_GAMMA_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Gamma(DX10_4)" );
		out.pData = &( MEP_PS_GAMMA_4[0] );
		out.dataSize = sizeof( MEP_PS_GAMMA_4 );
		break;

	case EffectPackage::SHADER_CAM_MOTION_BLUR_L_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"CameraMotionBlur_Low(DX10_4)" );
		out.pData = &( MEP_PS_CAM_MOTION_BLUR_L_4[0] );
		out.dataSize = sizeof( MEP_PS_CAM_MOTION_BLUR_L_4 );
		break;
	case EffectPackage::SHADER_CAM_MOTION_BLUR_M_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"CameraMotionBlur_Middle(DX10_4)" );
		out.pData = &( MEP_PS_CAM_MOTION_BLUR_M_4[0] );
		out.dataSize = sizeof( MEP_PS_CAM_MOTION_BLUR_M_4 );
		break;
	case EffectPackage::SHADER_CAM_MOTION_BLUR_H_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"CameraMotionBlur_High(DX10_4)" );
		out.pData = &( MEP_PS_CAM_MOTION_BLUR_H_4[0] );
		out.dataSize = sizeof( MEP_PS_CAM_MOTION_BLUR_H_4 );
		break;

	case EffectPackage::SHADER_CA_IMAGE___PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Chromatism_Image_(DX10_4)" );
		out.pData = &( MEP_PS_CA_IMAGE___4[0] );
		out.dataSize = sizeof( MEP_PS_CA_IMAGE___4 );
		break;
	case EffectPackage::SHADER_CA_IMAGE_K_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Chromatism_ImageK(DX10_4)" );
		out.pData = &( MEP_PS_CA_IMAGE_K_4[0] );
		out.dataSize = sizeof( MEP_PS_CA_IMAGE_K_4 );
		break;
	case EffectPackage::SHADER_CA_FINISH___PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Chromatism_Finish_(DX10_4)" );
		out.pData = &( MEP_PS_CA_FINISH___4[0] );
		out.dataSize = sizeof( MEP_PS_CA_FINISH___4 );
		break;
	case EffectPackage::SHADER_CA_FINISH_D_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Chromatism_FinishD(DX10_4)" );
		out.pData = &( MEP_PS_CA_FINISH_D_4[0] );
		out.dataSize = sizeof( MEP_PS_CA_FINISH_D_4 );
		break;

	case EffectPackage::SHADER_DOF_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"DepthOfField(DX10_4)" );
		out.pData = &( MEP_PS_DOF_4[0] );
		out.dataSize = sizeof( MEP_PS_DOF_4 );
		break;

	case EffectPackage::SHADER_LENS_DIST___PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensDistortion_(DX10_4)" );
		out.pData = &( MEP_PS_LENS_DIST___4[0] );
		out.dataSize = sizeof( MEP_PS_LENS_DIST___4 );
		break;
	case EffectPackage::SHADER_LENS_DIST_K_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensDistortionK(DX10_4)" );
		out.pData = &( MEP_PS_LENS_DIST_K_4[0] );
		out.dataSize = sizeof( MEP_PS_LENS_DIST_K_4 );
		break;

	case EffectPackage::SHADER_VIGNETTE_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Vignette(DX10_4)" );
		out.pData = &( MEP_PS_VIGNETTE_4[0] );
		out.dataSize = sizeof( MEP_PS_VIGNETTE_4 );
		break;

	case EffectPackage::SHADER_AA_FXAA_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"FXAA(DX10_4)" );
		out.pData = &( MEP_PS_FXAA_4[0] );
		out.dataSize = sizeof( MEP_PS_FXAA_4 );
		break;

	default:
		MIX_ERROR_W( L"w肳ꂽ풓VF[_[݂͑܂(SM4)" );
	}
}

}}}}
