#include "Mix/Private/Scene/Standard/DX11/EffectPackage.h"
#include "Mix/Private/Scene/Standard/DX11/EffectResource.h"

namespace Mix{ namespace Scene{ namespace Standard{ namespace DX11{

EffectPackage* EffectPackage::CreateInstance( const wchar_t* pDirPath, const wchar_t* pName, const wchar_t* pFilePath )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_SCENE, EffectPackage, pDirPath, pName, pFilePath );
}

EffectPackage::EffectPackage( const wchar_t* pDirPath, const wchar_t* pName, const wchar_t* pFilePath ) :
	Mix::Scene::Standard::Common::EffectPackage( pDirPath, pName, pFilePath )
{
}

EffectPackage::~EffectPackage( void )
{
}

void EffectPackage::GetShaderBinary( EffectPackage::SHADER_TYPES type, EffectPackage::SHADER_BINARY& out )
{
	switch( type )
	{
	// Misc //

	case EffectPackage::SHADER_SAMPLING_VS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Sampling(DX11_5)" );
		out.pData = &( MEP_VS_SAMPLING_5[0] );
		out.dataSize = sizeof( MEP_VS_SAMPLING_5 );
		break;
	case EffectPackage::SHADER_SAMPLING_COPY_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SamplingCopy(DX11_5)" );
		out.pData = &( MEP_PS_SAMPLING_COPY_5[0] );
		out.dataSize = sizeof( MEP_PS_SAMPLING_COPY_5 );
		break;
	case EffectPackage::SHADER_SAMPLING_DOWN2X_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SamplingDown2x(DX11_5)" );
		out.pData = &( MEP_PS_SAMPLING_DOWN2X_5[0] );
		out.dataSize = sizeof( MEP_PS_SAMPLING_DOWN2X_5 );
		break;
	case EffectPackage::SHADER_SAMPLING_DOWN4X_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SamplingDown4x(DX11_5)" );
		out.pData = &( MEP_PS_SAMPLING_DOWN4X_5[0] );
		out.dataSize = sizeof( MEP_PS_SAMPLING_DOWN4X_5 );
		break;

	case EffectPackage::SHADER_BLUR3X_X_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Blur3x_X(DX11_5)" );
		out.pData = &( MEP_PS_BLUR3X_X_5[0] );
		out.dataSize = sizeof( MEP_PS_BLUR3X_X_5 );
		break;
	case EffectPackage::SHADER_BLUR3X_Y_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Blur3x_Y(DX11_5)" );
		out.pData = &( MEP_PS_BLUR3X_Y_5[0] );
		out.dataSize = sizeof( MEP_PS_BLUR3X_Y_5 );
		break;

	case EffectPackage::SHADER_BLUR5X_X_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Blur5x_X(DX11_5)" );
		out.pData = &( MEP_PS_BLUR5X_X_5[0] );
		out.dataSize = sizeof( MEP_PS_BLUR5X_X_5 );
		break;
	case EffectPackage::SHADER_BLUR5X_Y_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Blur5x_Y(DX11_5)" );
		out.pData = &( MEP_PS_BLUR5X_Y_5[0] );
		out.dataSize = sizeof( MEP_PS_BLUR5X_Y_5 );
		break;

	case EffectPackage::SHADER_GAUSSIAN_BLUR_X_VS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"GaussianBlur_X(DX11_5)" );
		out.pData = &( MEP_VS_GAUSSIAN_BLUR_X_5[0] );
		out.dataSize = sizeof( MEP_VS_GAUSSIAN_BLUR_X_5 );
		break;
	case EffectPackage::SHADER_GAUSSIAN_BLUR_X_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"GaussianBlur_X(DX11_5)" );
		out.pData = &( MEP_PS_GAUSSIAN_BLUR_X_5[0] );
		out.dataSize = sizeof( MEP_PS_GAUSSIAN_BLUR_X_5 );
		break;
	case EffectPackage::SHADER_GAUSSIAN_BLUR_Y_VS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"GaussianBlur_Y(DX11_5)" );
		out.pData = &( MEP_VS_GAUSSIAN_BLUR_Y_5[0] );
		out.dataSize = sizeof( MEP_VS_GAUSSIAN_BLUR_Y_5 );
		break;
	case EffectPackage::SHADER_GAUSSIAN_BLUR_Y_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"GaussianBlur_Y(DX11_5)" );
		out.pData = &( MEP_PS_GAUSSIAN_BLUR_Y_5[0] );
		out.dataSize = sizeof( MEP_PS_GAUSSIAN_BLUR_Y_5 );
		break;

	case EffectPackage::SHADER_GAUSSIAN_BLUR_EX_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"GaussianBlurEx(DX11_5)" );
		out.pData = &( MEP_PS_GAUSSIAN_BLUR_EX_5[0] );
		out.dataSize = sizeof( MEP_PS_GAUSSIAN_BLUR_EX_5 );
		break;

	case EffectPackage::SHADER_BP____PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"BrightPass__(DX11_5)" );
		out.pData = &( MEP_PS_BRIGHTPASS____5[0] );
		out.dataSize = sizeof( MEP_PS_BRIGHTPASS____5 );
		break;
	case EffectPackage::SHADER_BP_L__PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"BrightPassL_(DX11_5)" );
		out.pData = &( MEP_PS_BRIGHTPASS_L__5[0] );
		out.dataSize = sizeof( MEP_PS_BRIGHTPASS_L__5 );
		break;
	case EffectPackage::SHADER_BP_LA_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"BrightPassLA(DX11_5)" );
		out.pData = &( MEP_PS_BRIGHTPASS_LA_5[0] );
		out.dataSize = sizeof( MEP_PS_BRIGHTPASS_LA_5 );
		break;

	// SkyDome //

	case EffectPackage::SHADER_SKYDOME_DEFAULT_VS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default ---- (DX11_5)" );
		out.pData = &( MEP_VS_SKYDOME_DEFAULT_5[0] );
		out.dataSize = sizeof( MEP_VS_SKYDOME_DEFAULT_5 );
		break;
	case EffectPackage::SHADER_SKYDOME_DEFAULT______PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default ---- (DX11_5)" );
		out.pData = &( MEP_PS_SKYDOME_DEFAULT______5[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_DEFAULT______5 );
		break;
	case EffectPackage::SHADER_SKYDOME_DEFAULT__C___PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default -C--- (DX11_5)" );
		out.pData = &( MEP_PS_SKYDOME_DEFAULT__C___5[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_DEFAULT__C___5 );
		break;
	case EffectPackage::SHADER_SKYDOME_DEFAULT__C2__PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default -C2- (DX11_5)" );
		out.pData = &( MEP_PS_SKYDOME_DEFAULT__C2__5[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_DEFAULT__C2__5 );
		break;
	case EffectPackage::SHADER_SKYDOME_DEFAULT_B____PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default B--- (DX11_5)" );
		out.pData = &( MEP_PS_SKYDOME_DEFAULT_B____5[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_DEFAULT_B____5 );
		break;
	case EffectPackage::SHADER_SKYDOME_DEFAULT_BC___PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default BC-- (DX11_5)" );
		out.pData = &( MEP_PS_SKYDOME_DEFAULT_BC___5[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_DEFAULT_BC___5 );
		break;
	case EffectPackage::SHADER_SKYDOME_DEFAULT_BC2__PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default BC2- (DX11_5)" );
		out.pData = &( MEP_PS_SKYDOME_DEFAULT_BC2__5[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_DEFAULT_BC2__5 );
		break;

	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE_VS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere ---- (DX11_5)" );
		out.pData = &( MEP_VS_SKYDOME_ATMOSPHERE_5[0] );
		out.dataSize = sizeof( MEP_VS_SKYDOME_ATMOSPHERE_5 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE______PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere ---- (DX11_5)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE______5[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE______5 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE__C___PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere -C--- (DX11_5)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE__C___5[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE__C___5 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE__C_L_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere -C--L (DX11_5)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE__C_L_5[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE__C_L_5 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE__C2__PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere -C2- (DX11_5)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE__C2__5[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE__C2__5 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE__C2L_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere -C2L (DX11_5)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE__C2L_5[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE__C2L_5 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE_B____PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere B--- (DX11_5)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE_B____5[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE_B____5 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE_BC___PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere BC-- (DX11_5)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE_BC___5[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE_BC___5 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE_BC_L_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere BC-L (DX11_5)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE_BC_L_5[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE_BC_L_5 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE_BC2__PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere BC2- (DX11_5)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE_BC2__5[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE_BC2__5 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE_BC2L_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere BC2L (DX11_5)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE_BC2L_5[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE_BC2L_5 );
		break;

	case EffectPackage::SHADER_SKYDOME_PANORAMA_VS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Panorama -- (DX11_5)" );
		out.pData = &( MEP_VS_SKYDOME_PANORAMA_5[0] );
		out.dataSize = sizeof( MEP_VS_SKYDOME_PANORAMA_5 );
		break;
	case EffectPackage::SHADER_SKYDOME_PANORAMA_FA_VS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Panorama FA (DX11_5)" );
		out.pData = &( MEP_VS_SKYDOME_PANORAMA_FA_5[0] );
		out.dataSize = sizeof( MEP_VS_SKYDOME_PANORAMA_FA_5 );
		break;
	case EffectPackage::SHADER_SKYDOME_PANORAMA_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Panorama -- (DX11_5)" );
		out.pData = &( MEP_PS_SKYDOME_PANORAMA_5[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_PANORAMA_5 );
		break;
	case EffectPackage::SHADER_SKYDOME_PANORAMA_FD_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Panorama FD (DX11_5)" );
		out.pData = &( MEP_PS_SKYDOME_PANORAMA_FD_5[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_PANORAMA_FD_5 );
		break;
	case EffectPackage::SHADER_SKYDOME_PANORAMA_FA_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Panorama FA (DX11_5)" );
		out.pData = &( MEP_PS_SKYDOME_PANORAMA_FA_5[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_PANORAMA_FA_5 );
		break;

	// PostEffect //

	case EffectPackage::SHADER_SSAO_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SSAO(DX11_5)" );
		out.pData = &( MEP_PS_SSAO_5[0] );
		out.dataSize = sizeof( MEP_PS_SSAO_5 );
		break;
	case EffectPackage::SHADER_SSAO_TEX_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SSAO_Tex(DX11_5)" );
		out.pData = &( MEP_PS_SSAO_TEX_5[0] );
		out.dataSize = sizeof( MEP_PS_SSAO_TEX_5 );
		break;

	case EffectPackage::SHADER_SM_FINISH____PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SM_Finish -- (DX11_5)" );
		out.pData = &( MEP_PS_SM_FINISH____5[0] );
		out.dataSize = sizeof( MEP_PS_SM_FINISH____5 );
		break;
	case EffectPackage::SHADER_SM_FINISH__B_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SM_Finish -B (DX11_5)" );
		out.pData = &( MEP_PS_SM_FINISH__B_5[0] );
		out.dataSize = sizeof( MEP_PS_SM_FINISH__B_5 );
		break;
	case EffectPackage::SHADER_SM_FINISH_R__PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SM_Finish R- (DX11_5)" );
		out.pData = &( MEP_PS_SM_FINISH_R__5[0] );
		out.dataSize = sizeof( MEP_PS_SM_FINISH_R__5 );
		break;
	case EffectPackage::SHADER_SM_FINISH_RB_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SM_Finish RB (DX11_5)" );
		out.pData = &( MEP_PS_SM_FINISH_RB_5[0] );
		out.dataSize = sizeof( MEP_PS_SM_FINISH_RB_5 );
		break;

	case EffectPackage::SHADER_UNDER_WATER_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"UnderWater(DX11_5)" );
		out.pData = &( MEP_PS_UNDER_WATER_5[0] );
		out.dataSize = sizeof( MEP_PS_UNDER_WATER_5 );
		break;

	case EffectPackage::SHADER_LUM_TRANSFORM_INITAL_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LumTransform_Inital(DX11_5)" );
		out.pData = &( MEP_PS_LUM_TRANSFORM_INITAL_5[0] );
		out.dataSize = sizeof( MEP_PS_LUM_TRANSFORM_INITAL_5 );
		break;
	case EffectPackage::SHADER_LUM_TRANSFORM_ITERATE_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LumTransform_Iterate(DX11_5)" );
		out.pData = &( MEP_PS_LUM_TRANSFORM_ITERATE_5[0] );
		out.dataSize = sizeof( MEP_PS_LUM_TRANSFORM_ITERATE_5 );
		break;
	case EffectPackage::SHADER_LUM_TRANSFORM_FINAL_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LumTransform_Final(DX11_5)" );
		out.pData = &( MEP_PS_LUM_TRANSFORM_FINAL_5[0] );
		out.dataSize = sizeof( MEP_PS_LUM_TRANSFORM_FINAL_5 );
		break;
	case EffectPackage::SHADER_LUM_ADAPTED_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LumAdapted(DX11_5)" );
		out.pData = &( MEP_PS_LUM_ADAPTED_5[0] );
		out.dataSize = sizeof( MEP_PS_LUM_ADAPTED_5 );
		break;
	case EffectPackage::SHADER_LUM_OPERATOR___B_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LumOperator__B(DX11_5)" );
		out.pData = &( MEP_PS_LUM_OPERATOR___B_5[0] );
		out.dataSize = sizeof( MEP_PS_LUM_OPERATOR___B_5 );
		break;
	case EffectPackage::SHADER_LUM_OPERATOR_T___PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LumOperatorT__(DX11_5)" );
		out.pData = &( MEP_PS_LUM_OPERATOR_T___5[0] );
		out.dataSize = sizeof( MEP_PS_LUM_OPERATOR_T___5 );
		break;
	case EffectPackage::SHADER_LUM_OPERATOR_T_B_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LumOperatorT_B(DX11_5)" );
		out.pData = &( MEP_PS_LUM_OPERATOR_T_B_5[0] );
		out.dataSize = sizeof( MEP_PS_LUM_OPERATOR_T_B_5 );
		break;
	case EffectPackage::SHADER_LUM_OPERATOR_TA__PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LumOperatorTA_(DX11_5)" );
		out.pData = &( MEP_PS_LUM_OPERATOR_TA__5[0] );
		out.dataSize = sizeof( MEP_PS_LUM_OPERATOR_TA__5 );
		break;
	case EffectPackage::SHADER_LUM_OPERATOR_TAB_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LumOperatorTAB(DX11_5)" );
		out.pData = &( MEP_PS_LUM_OPERATOR_TAB_5[0] );
		out.dataSize = sizeof( MEP_PS_LUM_OPERATOR_TAB_5 );
		break;

	case EffectPackage::SHADER_LS_INIT___PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LightShaftsInit_(DX11_5)" );
		out.pData = &( MEP_PS_LS_INIT___5[0] );
		out.dataSize = sizeof( MEP_PS_LS_INIT___5 );
		break;
	case EffectPackage::SHADER_LS_INIT_A_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LightShaftsInitA(DX11_5)" );
		out.pData = &( MEP_PS_LS_INIT_A_5[0] );
		out.dataSize = sizeof( MEP_PS_LS_INIT_A_5 );
		break;
	case EffectPackage::SHADER_LS_BLUR_L_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LightShaftsBlur_Low(DX11_5)" );
		out.pData = &( MEP_PS_LS_BLUR_L_5[0] );
		out.dataSize = sizeof( MEP_PS_LS_BLUR_L_5 );
		break;
	case EffectPackage::SHADER_LS_BLUR_M_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LightShaftsBlur_Middle(DX11_5)" );
		out.pData = &( MEP_PS_LS_BLUR_M_5[0] );
		out.dataSize = sizeof( MEP_PS_LS_BLUR_M_5 );
		break;
	case EffectPackage::SHADER_LS_BLUR_H_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LightShaftsBlur_High(DX11_5)" );
		out.pData = &( MEP_PS_LS_BLUR_H_5[0] );
		out.dataSize = sizeof( MEP_PS_LS_BLUR_H_5 );
		break;

	case EffectPackage::SHADER_LF_IMAGE____PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensFlare_Image___(DX11_5)" );
		out.pData = &( MEP_PS_LF_IMAGE____5[0] );
		out.dataSize = sizeof( MEP_PS_LF_IMAGE____5 );
		break;
	case EffectPackage::SHADER_LF_IMAGE__H_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensFlare_Image_H(DX11_5)" );
		out.pData = &( MEP_PS_LF_IMAGE__H_5[0] );
		out.dataSize = sizeof( MEP_PS_LF_IMAGE__H_5 );
		break;
	case EffectPackage::SHADER_LF_IMAGE_G__PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensFlare_Image_G_(DX11_5)" );
		out.pData = &( MEP_PS_LF_IMAGE_G__5[0] );
		out.dataSize = sizeof( MEP_PS_LF_IMAGE_G__5 );
		break;
	case EffectPackage::SHADER_LF_IMAGE_GH_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensFlare_ImageGH(DX11_5)" );
		out.pData = &( MEP_PS_LF_IMAGE_GH_5[0] );
		out.dataSize = sizeof( MEP_PS_LF_IMAGE_GH_5 );
		break;
	case EffectPackage::SHADER_LF_MODIFY____PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensFlare_Modify__(DX11_5)" );
		out.pData = &( MEP_PS_LF_MODIFY____5[0] );
		out.dataSize = sizeof( MEP_PS_LF_MODIFY____5 );
		break;
	case EffectPackage::SHADER_LF_MODIFY_D__PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensFlare_ModifyD_(DX11_5)" );
		out.pData = &( MEP_PS_LF_MODIFY_D__5[0] );
		out.dataSize = sizeof( MEP_PS_LF_MODIFY_D__5 );
		break;
	case EffectPackage::SHADER_LF_MODIFY__B_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensFlare_Modify_B(DX11_5)" );
		out.pData = &( MEP_PS_LF_MODIFY__B_5[0] );
		out.dataSize = sizeof( MEP_PS_LF_MODIFY__B_5 );
		break;
	case EffectPackage::SHADER_LF_MODIFY_DB_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensFlare_ModifyDB(DX11_5)" );
		out.pData = &( MEP_PS_LF_MODIFY_DB_5[0] );
		out.dataSize = sizeof( MEP_PS_LF_MODIFY_DB_5 );
		break;

	case EffectPackage::SHADER_FI_HEJL_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"FilmicHejl(DX11_5)" );
		out.pData = &( MEP_PS_FILMIC_HEJL_5[0] );
		out.dataSize = sizeof( MEP_PS_FILMIC_HEJL_5 );
		break;
	case EffectPackage::SHADER_FI_HABLE_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"FilmicHable(DX11_5)" );
		out.pData = &( MEP_PS_FILMIC_HABLE_5[0] );
		out.dataSize = sizeof( MEP_PS_FILMIC_HABLE_5 );
		break;

	case EffectPackage::SHADER_GAMMA_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Gamma(DX11_5)" );
		out.pData = &( MEP_PS_GAMMA_5[0] );
		out.dataSize = sizeof( MEP_PS_GAMMA_5 );
		break;

	case EffectPackage::SHADER_CAM_MOTION_BLUR_L_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"CameraMotionBlur_Low(DX11_5)" );
		out.pData = &( MEP_PS_CAM_MOTION_BLUR_L_5[0] );
		out.dataSize = sizeof( MEP_PS_CAM_MOTION_BLUR_L_5 );
		break;
	case EffectPackage::SHADER_CAM_MOTION_BLUR_M_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"CameraMotionBlur_Middle(DX11_5)" );
		out.pData = &( MEP_PS_CAM_MOTION_BLUR_M_5[0] );
		out.dataSize = sizeof( MEP_PS_CAM_MOTION_BLUR_M_5 );
		break;
	case EffectPackage::SHADER_CAM_MOTION_BLUR_H_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"CameraMotionBlur_High(DX11_5)" );
		out.pData = &( MEP_PS_CAM_MOTION_BLUR_H_5[0] );
		out.dataSize = sizeof( MEP_PS_CAM_MOTION_BLUR_H_5 );
		break;

	case EffectPackage::SHADER_CA_IMAGE___PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Chromatism_Image_(DX11_5)" );
		out.pData = &( MEP_PS_CA_IMAGE___5[0] );
		out.dataSize = sizeof( MEP_PS_CA_IMAGE___5 );
		break;
	case EffectPackage::SHADER_CA_IMAGE_K_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Chromatism_ImageK(DX11_5)" );
		out.pData = &( MEP_PS_CA_IMAGE_K_5[0] );
		out.dataSize = sizeof( MEP_PS_CA_IMAGE_K_5 );
		break;
	case EffectPackage::SHADER_CA_FINISH___PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Chromatism_Finish_(DX11_5)" );
		out.pData = &( MEP_PS_CA_FINISH___5[0] );
		out.dataSize = sizeof( MEP_PS_CA_FINISH___5 );
		break;
	case EffectPackage::SHADER_CA_FINISH_D_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Chromatism_FinishD(DX11_5)" );
		out.pData = &( MEP_PS_CA_FINISH_D_5[0] );
		out.dataSize = sizeof( MEP_PS_CA_FINISH_D_5 );
		break;

	case EffectPackage::SHADER_DOF_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"DepthOfField(DX11_5)" );
		out.pData = &( MEP_PS_DOF_5[0] );
		out.dataSize = sizeof( MEP_PS_DOF_5 );
		break;

	case EffectPackage::SHADER_LENS_DIST___PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensDistortion_(DX11_5)" );
		out.pData = &( MEP_PS_LENS_DIST___5[0] );
		out.dataSize = sizeof( MEP_PS_LENS_DIST___5 );
		break;
	case EffectPackage::SHADER_LENS_DIST_K_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensDistortionK(DX11_5)" );
		out.pData = &( MEP_PS_LENS_DIST_K_5[0] );
		out.dataSize = sizeof( MEP_PS_LENS_DIST_K_5 );
		break;

	case EffectPackage::SHADER_VIGNETTE_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Vignette(DX11_5)" );
		out.pData = &( MEP_PS_VIGNETTE_5[0] );
		out.dataSize = sizeof( MEP_PS_VIGNETTE_5 );
		break;

	case EffectPackage::SHADER_AA_FXAA_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"FXAA(DX11_5)" );
		out.pData = &( MEP_PS_FXAA_5[0] );
		out.dataSize = sizeof( MEP_PS_FXAA_5 );
		break;

	default:
		MIX_ERROR_W( L"w肳ꂽ풓VF[_[݂͑܂(SM5)" );
	}
}

}}}}
