#pragma once

#include "Mix/Private/Scene/Standard/Common/Renderer.h"

namespace Mix{ namespace Scene{ namespace Standard{ namespace DX9{

	class Renderer : public Mix::Scene::Standard::Common::Renderer
	{
	private:
		enum VSR
		{
			VSR_VIEW_MAT		= 16,
			VSR_VIEWPROJ_MAT	= 20,
			VSR_LIGHT_MAT		= 24,
			VSR_LIGHTBIAS_MAT	= 28,
			VSR_WORLD_MAT		= 32,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// KEVAu[
			////////////////////////////////////////////////////////////////////////////////////////////////////

			VSR_GAUSSIAN_BLUR_OFFSETS = 0,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// XJCh[ : ftHg
			////////////////////////////////////////////////////////////////////////////////////////////////////

			VSR_SD_WVP_MAT			= 0,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// XJCh[ : CUV~[V
			////////////////////////////////////////////////////////////////////////////////////////////////////

			VSR_AS_W_MAT			= 0,
			VSR_AS_WVP_MAT			= 4,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// XJCh[ : pm}
			////////////////////////////////////////////////////////////////////////////////////////////////////

			VSR_PR_WVP_MAT			= 0,
			VSR_PR_W_MAT			= 4, //CUV~[VLȏꍇ̂ݎgp
		};

		enum PSR
		{
			////////////////////////////////////////////////////////////////////////////////////////////////////
			// }eA
			////////////////////////////////////////////////////////////////////////////////////////////////////

			PSR_FAR_Z_INV				= 16,
			PSR_EYE_POS					= 17,

			PSR_GROBAL_AMBIENT_COLOR	= 18,

			PSR_HS_AXIS					= 19,
			PSR_HS_GROUND_COLOR			= 20,
			PSR_HS_SKY_COLOR			= 21,

			PSR_SUN_DIR					= 22,
			PSR_SUN_COLOR				= 23,

			PSR_FOG_PARAM				= 24,
			PSR_FOG_COLOR				= 25,

			PSR_SHADOW_PARAM0			= 26,
			PSR_SHADOW_PARAM1			= 27,

			PSR_AS_COLOR				= 28,
			PSR_AS_SUN_DIR				= 29,
			PSR_AS_MULTIPLIERS			= 30,
			PSR_AS_HG					= 31,
			PSR_AS_BETA_DASH_R			= 32,
			PSR_AS_BETA_DASH_M			= 33,
			PSR_AS_BETA_RM				= 34,
			PSR_AS_ONE_OVER_BETA_RM		= 35,

			PSR_LOCAL_LIGHT_POS			= 48,
			PSR_LOCAL_LIGHT_DIR			= 52,
			PSR_LOCAL_LIGHT_ATTEN		= 56,
			PSR_LOCAL_LIGHT_COLOR		= 60,
			PSR_LOCAL_LIGHT_PARAM		= 64,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// TvO
			////////////////////////////////////////////////////////////////////////////////////////////////////

			PSR_SAMPLING_PARAM = 0,	//XY=eNZTCY Z=XP[ or XYZ=(1.0f / K}l)

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// u[
			////////////////////////////////////////////////////////////////////////////////////////////////////

			PSR_BLUR_PARAM = 0,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// KEVAu[ : ftHg
			////////////////////////////////////////////////////////////////////////////////////////////////////

			PSR_GAUSSIAN_BLUR_OFFSETS = 0,
			PSR_GAUSSIAN_BLUR_WEIGHTS = 1,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// KEVAu[ : GNZg
			////////////////////////////////////////////////////////////////////////////////////////////////////

			// Float32 SIGMA = static_cast<Float32>( radius ) * 0.125f; //radius / 8.0f
			// Float32 SIGMA2 = SIGMA * SIGMA;
			// Float32 E = expf( -0.5f / SIGMA2 );
			// Float32 E2 = E * E;

			PSR_GAUSSIAN_BLUR_EX_PARAM0 = 0, // X=radius / 2.0f( 2.0f <= numSample <= 64.0f )
			PSR_GAUSSIAN_BLUR_EX_PARAM1 = 1, // X=1.0f / ( sqrtf( MIX_2PI ) * SIGMA ) Y=E Z=E*E
			PSR_GAUSSIAN_BLUR_EX_PARAM2 = 2, // XY=TexelSize

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// uCgpX
			////////////////////////////////////////////////////////////////////////////////////////////////////

			PSR_BP_PARAM = 0,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// VhE}bsO
			////////////////////////////////////////////////////////////////////////////////////////////////////

			PSR_SM_PARAMS	= 0,	//X=FalloutStart Y=InvFalloutDist Z=RefractFactor
			PSR_SM_COLOR	= 1,	//XYZ=RGB W=Intensity

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// SSAO
			////////////////////////////////////////////////////////////////////////////////////////////////////

			PSR_SSAO_PARAM0	= 0,
			PSR_SSAO_PARAM1	= 1,
			PSR_SSAO_COLOR	= 2,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// ~iX
			////////////////////////////////////////////////////////////////////////////////////////////////////

			PSR_LUM_TRANSFORM_PARAM = 0, // XY=eNZTCY Z=ŏPx W=őPx
			PSR_LUM_ADAPTED_PARAM = 0,
			PSR_LUM_OPERATOR_PARAM = 0,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// DOF
			////////////////////////////////////////////////////////////////////////////////////////////////////

			PSR_DOF_PARAM0			= 0,
			PSR_DOF_PARAM1			= 1,
			PSR_DOF_SAMPLING_TABLE	= 2,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// FXAA
			////////////////////////////////////////////////////////////////////////////////////////////////////

			PSR_FXAA_TEXCOORDS			= 0,
			PSR_FXAA_INV_SCREEN_SIZE	= 2,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// XJCh[
			////////////////////////////////////////////////////////////////////////////////////////////////////

			// ftHg

			PSR_SD_DEF_BASE_COLOR	= 0,
			PSR_SD_DEF_BASE_PARAM	= 1,
			PSR_SD_DEF_CLOUD_COLOR	= 2,
			PSR_SD_DEF_CLOUD_LAYER	= 3,

			// C

			PSR_SD_AS_SUN_COLOR		= 0,
			PSR_SD_AS_NIGHT_COLOR	= 1,
			PSR_SD_AS_BASE_PARAM	= 2,
			PSR_SD_AS_CLOUD_COLOR	= 3,
			PSR_SD_AS_CLOUD_LAYER	= 4,
			PSR_SD_AS_CLOUD_PARAMS	= 6, //X=n臒l Y=n̔{ Z=ՒfĂ镔̈Â

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// XJCh[ : pm}
			////////////////////////////////////////////////////////////////////////////////////////////////////

			PSR_PR_BASE_COLOR		= 0,
			PSR_PR_PARAM			= 1,	// X=eNX`̃s[g Y= Z=tHO

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// ʉ
			////////////////////////////////////////////////////////////////////////////////////////////////////

			PSR_UW_COLOR			= 0,
			PSR_UW_PARAM			= 1,

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// CgVtg
			////////////////////////////////////////////////////////////////////////////////////////////////////

			// 

			PSR_LS_INIT_PARAM	= 0,	// XY=mCYeNX`̃AXyNg

			// u[

			PSR_LS_BLUR_PARAM0	= 0,	// XY=XN[̃CgW Z=EyeDir dot LightDir
			PSR_LS_BLUR_PARAM1	= 1,	// X=Density Y=Decay Z=Exposure
			PSR_LS_BLUR_PARAM2	= 2,	// X=FadeInStart Y=FadeInEnd Z=1.0f / ( FadeInEnd - FadeInStart )

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// YtA
			////////////////////////////////////////////////////////////////////////////////////////////////////

			// C[W

			PSR_LF_I_PARAM0		= 0,	//XYZ=c W=GhostNum
			PSR_LF_I_PARAM1		= 1,	//X=GhostWeight Y=GhostDispersion Z=HaloWeight W=HaloWidth

			// fBt@C

			PSR_LF_M_PARAM	= 0,	// X=DirtIntensity Y=DirtExposure Z=BrustIntensity W=BrustExposure
			PSR_LF_M_CAMMAT	= 1,	// J(uXg)̉]s

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// tB~bN
			////////////////////////////////////////////////////////////////////////////////////////////////////

			// Hable

			FI_HABLE_PARAM0	= 0,	//X=ExposureBias Y=ShoulderStrength Z=LinearStrength W=LinearAngle
			FI_HABLE_PARAM1	= 1,	//X=ToeStrength Y=ToeNumerator Z=ToeDenominator W=LinearWhitePointValue

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// J[Vu[
			////////////////////////////////////////////////////////////////////////////////////////////////////

			CMB_INV_VP_MAT	= 0,
			CMB_PRE_VP_MAT	= 4,
			CMB_PARAM0		= 8,	//X=2.0f * NearZ Y=Farz+NearZ Z=1.0f / -( FarZ - NearZ )
			CMB_PARAM1		= 9,	//X=Scale Y=Intensity Z=1.0f / volume W=dist / farZ

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// F
			////////////////////////////////////////////////////////////////////////////////////////////////////

			// C[W

			PSR_CA_IMAGE_PARAM			= 0,	//X=k Y=kCube Z=Scale
			PSR_CA_IMAGE_COLOR_FACTOR	= 1,	//XYZW=ColorFactor

			// tBjbV

			PSR_CA_FINISH_PARAM			= 0,	// X=weight Y=fadein_StartZ Z=fadein_InvDistance( 1.0f / ( fadein_EndZ - fadein_StartZ ) )

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// cȎ
			////////////////////////////////////////////////////////////////////////////////////////////////////

			PSR_LD_PARAM		= 0,	// X=k Y=kCube Z=scale

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// Blbg
			////////////////////////////////////////////////////////////////////////////////////////////////////

			PSR_VI_PARAMS	= 0,	// X=start Y=1.0f / ( end - start )
			PSR_VI_COLOR	= 1,	// XYZ=RGB W=A
		};

		enum LIGHT_TABLE_OFFSET
		{
			LTO_MAX		= 5,

			LTO_POS		= Renderer::LOCAL_LIGHT_MAX * 0,
			LTO_DIR		= Renderer::LOCAL_LIGHT_MAX * 1,
			LTO_ATTEN	= Renderer::LOCAL_LIGHT_MAX * 2,
			LTO_COLOR	= Renderer::LOCAL_LIGHT_MAX * 3,
			LTO_PARAM	= Renderer::LOCAL_LIGHT_MAX * 4,
		};

	private:
		Mix::STL::Vector<Mix::Memory::SECTION_SCENE, Mix::Vector4> m_VectorTable;

	public:
		static Renderer* CreateInstance( Mix::Scene::Standard::Common::EffectPackage* pEffectPackage, const wchar_t* pDebugName );

	private:
		Renderer( Mix::Scene::Standard::Common::EffectPackage* pEffectPackage, const wchar_t* pDebugName );
		virtual ~Renderer( void );

	protected:
		virtual void OnPrepareRendering( const Renderer::PREPARE_REDNERING_EVENT_ARGS& e );
		virtual void OnTransform( const Renderer::TRANSFORM_EVENT_ARGS& e );
		virtual void OnPlacementLocalLight( const Renderer::LOCALLIGHT_EVENT_ARGS& e );
		virtual void OnRenderSkyDome( const Renderer::SKYDOME_DEFAULT_EVENT_ARGS& e );
		virtual void OnRenderSkyDome( const Renderer::SKYDOME_ATMOSPHERE_EVENT_ARGS& e );
		virtual void OnRenderPanorama( const Renderer::SKYDOME_PANORAMA_EVENT_ARGS& e );

		virtual void OnRenderSampling( const Renderer::RENDER_SAMPLING_ARGS& e );
		virtual void OnRenderBlur( const Renderer::RENDER_BLUR_ARGS& e );
		virtual void OnRenderGaussianBlur( const Renderer::RENDER_GAUSSIAN_BLUR_ARGS& e );
		virtual void OnRenderGaussianBlurEx( const Renderer::RENDER_GAUSSIAN_BLUR_EX_ARGS& e );

		virtual void OnRenderShadowMapping( const Renderer::RENDER_SHADOW_MAPPING_ARGS& e );
		virtual void OnRenderAmbientOcclusion( const Renderer::RENDER_AMBIENT_OCCLUSION_ARGS& e );
		virtual void OnRenderLumTransform( const Renderer::RENDER_LUM_TRANSFORM_ARGS& e );
		virtual void OnRenderLumAdapted( const Renderer::RENDER_LUM_ADAPTED_ARGS& e );
		virtual void OnRenderLumOperator( const Renderer::RENDER_LUM_OPERATOR_ARGS& e );
		virtual void OnRenderBrightPass( const Renderer::RENDER_BRIGHTPASS_ARGS& e );
		virtual void OnRenderUnderWater( const Renderer::UNDERWATER_EVENT_ARGS& e );
		virtual void OnRenderLightShaftsInit( const Renderer::RENDER_LIGHT_SHAFTS_INIT_ARGS& e );
		virtual void OnRenderLightShaftsBlur( const Renderer::RENDER_LIGHT_SHAFTS_BLUR_ARGS& e );
		virtual void OnRenderLensFlareImage( const Renderer::RENDER_LENSFLARE_IMAGE_ARGS& e );
		virtual void OnRenderLensFlareModify( const Renderer::RENDER_LENSFLARE_MODIFY_ARGS& e );
		virtual void OnRenderFilmicHable( const Renderer::RENDER_FILMIC_HABLE_ARGS& e );
		virtual void OnRenderChromatismImage( const Renderer::RENDER_CHROMATISM_IMAGE_ARGS& e );
		virtual void OnRenderChromatismFinish( const Renderer::RENDER_CHROMATISM_FINISH_ARGS& e );
		virtual void OnRenderGammaCorrect( const Renderer::RENDER_GAMMA_ARGS& e );
		virtual void OnRenderCameraMotionBlur( const Renderer::RENDER_CAMERA_MOTION_BLUR_ARGS& e );
		virtual void OnRenderDof( const Renderer::RENDER_DOF_ARGS& e );
		virtual void OnRenderLensDistortion( const Renderer::RENDER_LENS_DISTORTION_ARGS& e );
		virtual void OnRenderVignette( const Renderer::RENDER_VIGNETTE_ARGS& e );
		virtual void OnRenderFXAA( const Renderer::RENDER_FXAA_ARGS& e );
	};

}}}}
