#include "Mix/Private/Sound/Listener.h"

namespace Mix{ namespace Sound{

Listener* Listener::CreateInstance( const Mix::Vector3& localFront, const Mix::Vector3& localUp )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_SOUND, Listener, localFront, localUp );
}

Listener::Listener( const Mix::Vector3& localFront, const Mix::Vector3& localUp ) :
m_LocalFront( localFront ),
m_LocalUp( localUp ),
m_WorldFront( localFront ),
m_WorldUp( localUp )
{
	m_Param.OrientFront.x = localFront.x;
	m_Param.OrientFront.y = localFront.y;
	m_Param.OrientFront.z = localFront.z;
	m_Param.OrientTop.x = localUp.x;
	m_Param.OrientTop.y = localUp.y;
	m_Param.OrientTop.z = localUp.z;
	m_Param.Position.x = 0.0f;
	m_Param.Position.y = 0.0f;
	m_Param.Position.z = 0.0f;
	m_Param.Velocity.x = 0.0f;
	m_Param.Velocity.y = 0.0f;
	m_Param.Velocity.z = 0.0f;
	m_Param.pCone = NULL;
}

Listener::~Listener( void )
{
}

const X3DAUDIO_LISTENER& Listener::GetParam( void ) const
{
	return m_Param;
}

const Mix::Vector3& Listener::GetLocalFront( void ) const
{
	return m_LocalFront;
}

const Mix::Vector3& Listener::GetLocalUp( void ) const
{
	return m_LocalUp;
}

const Mix::Matrix4x4& Listener::GetWorldMatrix( void ) const
{
	return m_WorldMatrix;
}

void Listener::SetWorldMatrix( const Mix::Matrix4x4& mat )
{
	m_WorldMatrix = mat;

	m_WorldFront = m_WorldMatrix.TransformSR( m_LocalFront );
	m_WorldFront.Normalize();

	m_WorldUp = m_WorldMatrix.TransformSR( m_LocalUp );
	m_WorldUp.Normalize();

	m_Param.OrientFront.x = m_WorldFront.x;
	m_Param.OrientFront.y = m_WorldFront.y;
	m_Param.OrientFront.z = m_WorldFront.z;
	m_Param.OrientTop.x = m_WorldUp.x;
	m_Param.OrientTop.y = m_WorldUp.y;
	m_Param.OrientTop.z = m_WorldUp.z;
	m_Param.Position.x = mat.m30;
	m_Param.Position.y = mat.m31;
	m_Param.Position.z = mat.m32;
}

const Mix::Vector3& Listener::GetWorldFront( void ) const
{
	return m_WorldFront;
}

const Mix::Vector3& Listener::GetWorldUp( void ) const
{
	return m_WorldUp;
}

const Mix::Vector3& Listener::GetVelocity( void ) const
{
	return m_Velocity;
}

void Listener::SetVelocity( const Mix::Vector3& velocity )
{
	m_Velocity = velocity;

	m_Param.Velocity.x = m_Velocity.x;
	m_Param.Velocity.y = m_Velocity.y;
	m_Param.Velocity.z = m_Velocity.z;
}

}}
