#pragma once

#include "Mix/Sound/IController.h"

namespace Mix{ namespace Sound{

	class Manager;

	class SimpleController : public Mix::Sound::IController
	{
	public:
		//p
		static SimpleController* CreateInstance( const Mix::Sound::SimpleController* pSrc, IXAudio2SourceVoice* pVoice );
		//ʏ쐬p
		static SimpleController* CreateInstance( const wchar_t* filePath, const WAVEFORMATEX* pFormat, IXAudio2SourceVoice* pVoice, Mix::Memory::IBuffer* pBuffer );

	private:
		Mix::String m_FilePath;
		WAVEFORMATEX m_Format;
		IXAudio2SourceVoice* m_pVoice;
		Mix::Memory::IBuffer* m_pBuffer;
		XAUDIO2_BUFFER m_Data;
		Int32 m_SuspendCount;
		Float32 m_Panpot;

	private:
		SimpleController( const Mix::Sound::SimpleController* pSrc, IXAudio2SourceVoice* pVoice );
		SimpleController( const wchar_t* fileName, const WAVEFORMATEX* pFormat, IXAudio2SourceVoice* pVoice, Mix::Memory::IBuffer* pBuffer );
		virtual ~SimpleController( void );

	public:
		const WAVEFORMATEX* GetFormat( void ) const;

	public:
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Sound::IController
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Float32 GetVolume( void ) const;
		virtual void SetVolume( Float32 volume );

		virtual Float32 GetPanpot( void ) const;
		virtual void SetPanpot( Float32 panpot );

		virtual Boolean IsCloneable( void ) const;
		virtual Boolean Clone( Mix::Sound::IController** ppController );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Sound::IDevice
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Boolean IsPlaying( void );
		virtual void Play( Boolean bLoop );
		virtual void Stop( void );

		virtual void Suspend( void );
		virtual void Resume( void );

		virtual Boolean IsDisposed( void );
		virtual void Dispose( void );

		virtual const wchar_t* GetFilePath( void ) const;
	};

}}
