#pragma once

#include "Mix/Sound/IController.h"

namespace Mix{ namespace Sound{

	class StreamingControllerMediator;

	class StreamingController : public Mix::Sound::IController
	{
	public:
		static StreamingController* CreateInstance( Mix::IO::IReader* pReader, Mix::Sound::StreamingControllerMediator* pMediator );

	private:
		Mix::IO::IReader* m_pReader;
		Mix::Sound::StreamingControllerMediator* m_pMediator;

	private:
		StreamingController( Mix::IO::IReader* pReader, Mix::Sound::StreamingControllerMediator* pMediator );
		virtual ~StreamingController( void );

	public:
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Sound::IController
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Float32 GetVolume( void ) const;
		virtual void SetVolume( Float32 volume );

		virtual Float32 GetPanpot( void ) const;
		virtual void SetPanpot( Float32 panpot );

		virtual Boolean IsCloneable( void ) const;
		virtual Boolean Clone( Mix::Sound::IController** ppController );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Sound::IDevice
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Boolean IsPlaying( void );
		virtual void Play( Boolean bLoop );
		virtual void Stop( void );

		virtual void Suspend( void );
		virtual void Resume( void );

		virtual Boolean IsDisposed( void );
		virtual void Dispose( void );

		virtual const wchar_t* GetFilePath( void ) const;
	};

}}
