#include "Mix/Private/Sound/StreamingControllerMediator.h"
#include "Mix/ScopedLock.h"

namespace Mix{ namespace Sound{

////////////////////////////////////////////////////////////////////////////////////////////////////
// StreamingControllerMediator::SyncFloat
////////////////////////////////////////////////////////////////////////////////////////////////////

StreamingControllerMediator::SyncFloat::SyncFloat( Float32 defValue ) :
m_Current( defValue ),
m_Next( defValue )
{
}

void StreamingControllerMediator::SyncFloat::SetNext( Float32 value )
{
	m_Sync.Enter();
	m_Next = value;
	m_Sync.Leave();
}

Float32 StreamingControllerMediator::SyncFloat::GetNext( void )
{
	Mix::ScopedLock lock( m_Sync );

	return m_Next;
}

Boolean StreamingControllerMediator::SyncFloat::GetCurrent( Float32& value )
{
	Mix::ScopedLock lock( m_Sync );

	Boolean bUpdate = False;

	if( m_Current != m_Next )
	{
		m_Current = m_Next;
		value = m_Current;
	}

	return bUpdate;
}


////////////////////////////////////////////////////////////////////////////////////////////////////
// StreamingControllerMediator
////////////////////////////////////////////////////////////////////////////////////////////////////

StreamingControllerMediator* StreamingControllerMediator::CreateInstance( void )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_SOUND, StreamingControllerMediator );
}

StreamingControllerMediator::StreamingControllerMediator( void ) :
m_Volume( 1.0f ),
m_Panpot( 0.0f )
{
}

StreamingControllerMediator::~StreamingControllerMediator( void )
{
}

void StreamingControllerMediator::SetVolume( Float32 value )
{
	m_Volume.SetNext( value );
}

void StreamingControllerMediator::SetPanpot( Float32 value )
{
	m_Panpot.SetNext( value );
}

Float32 StreamingControllerMediator::GetVolume( void )
{
	return m_Volume.GetNext();
}

Float32 StreamingControllerMediator::GetPanpot( void )
{
	return m_Panpot.GetNext();
}

Boolean StreamingControllerMediator::GetVolume( Float32& value )
{
	return m_Volume.GetCurrent( value );
}

Boolean StreamingControllerMediator::GetPanpot( Float32& value )
{
	return m_Panpot.GetCurrent( value );
}

}}
