#include "Mix/Timer.h"

namespace Mix{

Timer::Timer( void )
{
	m_Before.QuadPart = 0;
}

Timer::~Timer( void )
{
}

void Timer::Reset( void )
{
	::QueryPerformanceCounter( &m_Before );
}

UInt32 Timer::GetUI32( UInt64 resolution )
{
	if( resolution == 0 )
	{
		return 0;
	}

	LARGE_INTEGER freq;
	LARGE_INTEGER after;

	if( ( ::QueryPerformanceFrequency( &freq ) == FALSE ) ||
		( freq.QuadPart == 0 ) )
	{
		return 0;
	}

	if( ::QueryPerformanceCounter( &after ) == FALSE )
	{
		return 0;
	}

	return static_cast<UInt32>( ( after.QuadPart - m_Before.QuadPart ) * resolution / freq.QuadPart );
}

UInt64 Timer::GetUI64( UInt64 resolution )
{
	if( resolution == 0 )
	{
		return 0;
	}

	LARGE_INTEGER freq;
	LARGE_INTEGER after;

	if( ::QueryPerformanceFrequency( &freq ) == FALSE )
	{
		return 0;
	}

	if( ::QueryPerformanceCounter( &after ) == FALSE )
	{
		return 0;
	}

	return ( after.QuadPart - m_Before.QuadPart ) * resolution / freq.QuadPart;
}

Float32 Timer::GetF32( void )
{
	LARGE_INTEGER freq;
	LARGE_INTEGER after;

	if( ::QueryPerformanceFrequency( &freq ) == FALSE )
	{
		return 0.0f;
	}

	if( ::QueryPerformanceCounter( &after ) == FALSE )
	{
		return 0.0f;
	}

	return MIX_FLOAT_DIV( static_cast<Float32>( after.QuadPart - m_Before.QuadPart ), static_cast<Float32>( freq.QuadPart ) );
}

Float64 Timer::GetF64( void )
{
	LARGE_INTEGER freq;
	LARGE_INTEGER after;

	if( ::QueryPerformanceFrequency( &freq ) == FALSE )
	{
		return 0.0;
	}

	if( ::QueryPerformanceCounter( &after ) == FALSE )
	{
		return 0.0;
	}

	return MIX_FLOAT_DIV( static_cast<Float64>( after.QuadPart - m_Before.QuadPart ), static_cast<Float64>( freq.QuadPart ) );
}

}
