#pragma once

//! @file Mix/Rectangle.h
//! @brief `NXCN[ht@C

namespace Mix{

	class RectangleF;

	//! @class Rectangle
	//! @brief `NX
	class _MIX_DLL_API Rectangle
	{
	public:
		Int32 x;		//!< Ẍʒu
		Int32 y;		//!< Ÿʒu
		Int32 width;	//!< 
		Int32 height;	//!< 

	public:
		//! @brief RXgN^
		Rectangle( void );
		//! @brief RXgN^
		//! @param[in] rx Ẍʒu
		//! @param[in] ry Ÿʒu
		//! @param[in] rw 
		//! @param[in] rh 
		Rectangle( Int32 rx, Int32 ry, Int32 rw, Int32 rh );
		//! @brief Rs[RXgN^
		//! @param[in] rect `
		Rectangle( const Mix::Rectangle& rect );
		//! @brief Rs[RXgN^
		//! @param[in] rect `
		Rectangle( const Mix::RectangleF& rect );

		//! @brief r
		//! @param[in] rect r`
		//! @return lꍇ True Ԃ܂
		Boolean operator == ( const Rectangle& rect ) const;
		//! @brief r
		//! @param[in] rect r`
		//! @return lȂꍇ True Ԃ܂
		Boolean operator != ( const Rectangle& rect ) const;

		//! @brief ( = )
		//! @param[in] rect 
		//! @return 
		Mix::Rectangle& operator = ( const Mix::Rectangle& rect );
		//! @brief ( = )
		//! @param[in] rect 
		//! @return 
		Mix::Rectangle& operator = ( const Mix::RectangleF& rect );

		//! @brief `ݒ肵܂
		//! @param[in] rx `̍ X W
		//! @param[in] ry `̍ Y W
		//! @param[in] rw `̕
		//! @param[in] rh `̍
		void Set( Int32 rx, Int32 ry, Int32 rw, Int32 rh );

		//! @brief w肵_܂܂Ă邩`FbN܂
		//! @param[in] p _\ Mix::Point NX
		//! @return _܂܂Ăꍇ True Ԃ܂
		Boolean Contains( const Mix::Point& p ) const;
		//! @brief w肵`܂܂Ă邩`FbN܂
		//! @param[in] rect `\ Mix::Rectangle NX
		//! @param[out] pOverlapRect dȂĂ`\ Mix::Rectangle NX̃|C^
		//! @return `܂܂Ăꍇ True Ԃ܂
		Boolean Contains( const Mix::Rectangle& rect, Mix::Rectangle* pOverlapRect = NULL ) const;

		//! @brief `̉E[XW擾܂
		//! @return E[XW
		Int32 GetRight( void ) const;
		//! @brief `̉E[XWݒ肵܂
		//! @param[in] right E[XW
		void SetRight( Int32 right );
		//! @brief `̉[YW擾܂
		//! @return [YW
		Int32 GetBottom( void ) const;
		//! @brief `̉[YWݒ肵܂
		//! @param[in] bottom [YW
		void SetBottom( Int32 bottom );

	public:
		//! @brief l( 0, 0, 0, 0 )擾܂
		//! @return l\ Mix::Rectangle NXԂ܂
		static const Mix::Rectangle& Zero( void )
		{
			static const Mix::Rectangle zero( 0, 0, 0, 0 );

			return zero;
		}
	};

}
