#pragma once

//! @file Mix/Scene/IDynamicsObject.h
//! @brief _Ci~NXIuWFNgC^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Scene{

	//! @class IDynamicsObject
	//! @brief _Ci~NXIuWFNgC^[tF[X
	class IDynamicsObject : public Mix::Reference
	{
	public:
		//! @enum TYPE
		//! @brief ^Cv񋓒萔
		enum TYPE
		{
			UNDEFINED					= 0,	//!< `ĂȂ_Ci~NXIuWFNg
			SIMPLE_COLLIDER				= 1,	//!< VvRC_[
			LIBERTY_COLLIDER			= 2,	//!< oeBRC_[
			ACTOR_COLLIDER				= 3,	//!< AN^[RC_[
			TERRAIN_COLLIDER			= 4,	//!< eCRC_[
			SIMPLE_SENSOR				= 5,	//!< VvZT[
			ACTOR_SENSOR				= 6,	//!< AN^[ZT[
			SIMPLE_KINEMATIC_CHARACTER	= 7,	//!< VvLl}eBbNLN^[
			ACTOR_KINEMATIC_CHARACTER	= 8,	//!< AN^[Ll}eBbNLN^[
		};

	protected:
		//! @brief fXgN^
		virtual ~IDynamicsObject( void ) {}

	public:
		//! @brief ނ擾܂
		//! @return ނ\ Mix::Scene::IDynamicsObject::TYPE 񋓒萔Ԃ܂
		virtual Mix::Scene::IDynamicsObject::TYPE GetType( void ) const = 0;

		//! @brief I[i[擾܂
		//! @param[out] ppOwner 擾I[i[n Mix::Scene::IRendererObject C^[tF[X̃|C^̃AhX
		virtual Boolean GetOwner( Mix::Scene::IRendererObject** ppOwner ) = 0;
		//! @brief I[i[̃|C^擾܂
		//! @return I[i[̃|C^\ Mix::Scene::IRendererObject C^[tF[X̃|C^Ԃ܂
		virtual Mix::Scene::IRendererObject* GetOwnerPtr( void ) const = 0;

		//! @brief [hs擾܂
		//! @return [hs\ Mix::Matrix4x4 NXԂ܂
		virtual Mix::Matrix4x4 GetWorldMatrix( void ) const = 0;
		//! @brief [h̉]擾܂
		//! @return [h̉]\ Mix::Quaternion NXԂ܂
		virtual Mix::Quaternion GetWorldRotation( void ) const = 0;
		//! @brief [ḧʒu擾܂
		//! @return [ḧʒu\ Mix::Vector3 NXԂ܂
		virtual Mix::Vector3 GetWorldPosition( void ) const = 0;

		//! @brief R^NgXi[Ă邩ǂ擾܂
		//! @return R^NgXi[Ăꍇ True Ԃ܂
		virtual Boolean HasContactListener( void ) const = 0;
		//! @brief w肵R^NgXi[݂Ă邩ǂmF܂
		//! @param[in] pListener mFR^NgXi[\ Mix::Scene::IContactListener C^[tF[X̃|C^
		//! @return ݂Ăꍇ True Ԃ܂
		virtual Boolean ContainsContactListener( Mix::Scene::IContactListener* pListener ) const = 0;
		//! @brief R^NgXi[ǉ܂
		//! @param[in] pListener ǉR^NgXi[\ Mix::Scene::IContactListener C^[tF[X̃|C^
		//! @return ꍇ True Ԃ܂
		//! @note ǉR^NgXi[͎QƃJE^ +1 ܂
		virtual Boolean AddContactListener( Mix::Scene::IContactListener* pListener ) = 0;
		//! @brief R^NgXi[폜܂
		//! @param[in] pListener 폜R^NgXi[\ Mix::Scene::IContactListener C^[tF[X̃|C^
		//! @return ꍇ True Ԃ܂
		//! @note 폜R^NgXi[͎QƃJE^ -1 ܂
		virtual Boolean RemoveContactListener( Mix::Scene::IContactListener* pListener ) = 0;
		//! @brief SẴR^NgXi[폜܂
		//! @note 폜R^NgXi[͎QƃJE^ -1 ܂
		virtual void ClearContactListener( void ) = 0;

		//! @brief [U[CfbNX擾܂
		//! @return CfbNXԂ܂
		virtual Int32 GetUserIndex( void )  const = 0;
		//! @brief [U[CfbNXݒ肵܂
		//! @param index CfbNX
		//! @note ̒l̓[U[RɎgpł܂
		virtual void SetUserIndex( Int32 index ) = 0;

		//! @brief [U[|C^擾܂
		//! @return |C^Ԃ܂
		virtual void* GetUserPtr( void ) const = 0;
		//! @brief [U[|C^ݒ肵܂
		//! @param pData |C^
		//! @note ̒l̓[U[RɎgpł܂
		virtual void SetUserPtr( void* pData ) = 0;
	};

}}
