#pragma once

//! @file Mix/Scene/ILibertyCollider.h"
//! @brief oeBRC_[C^[tF[XCN[ht@C

#include "Mix/Dynamics/IRigidBody.h"
#include "Mix/Scene/IKineticCollider.h"

namespace Mix{ namespace Scene{

	//! @class ILibertyCollider
	//! @brief oeBRC_[C^[tF[X
	class ILibertyCollider : public Mix::Scene::IKineticCollider
	{
	protected:
		//! @brief fXgN^
		virtual ~ILibertyCollider( void ) {}

	public:
		//! @brief V~[VLǂ擾܂
		//! @return Lȏꍇ True Ԃ܂
		virtual Boolean IsSimulationEnabled( void ) const = 0;
		//! @brief V~[VLɂ邩ǂݒ肵܂
		//! @param[in] state Lɂꍇ True
		virtual void SetSimulationEnabled( Boolean state ) = 0;

		//! @brief Ԃ擾܂
		//! @return Ԃ\ Mix::Dynamics::IRigidBody::STATUS 񋓒萔Ԃ܂
		virtual Mix::Dynamics::IRigidBody::STATUS GetStatus( void ) const = 0;
		//! @brief Ԃݒ肵܂
		//! @param[in] status Ԃ\ Mix::Dynamics::IRigidBody::STATUS 񋓒萔
		//! @return ꍇ True Ԃ܂
		//! @note ʂȌԂŃXe[^XftHgɐݒ肵悤ƂꍇÃ\bh False Ԃ܂
		virtual Boolean SetStatus( Mix::Dynamics::IRigidBody::STATUS status ) = 0;

		//! @brief tB^[O[v擾܂
		//! @return tB^[O[vԂ܂
		virtual UInt16 GetFilterGroup( void ) const = 0;
		//! @brief tB^[O[vݒ肵܂
		//! @param[in] filterGroup tB^[O[v
		virtual void SetFilterGroup( UInt16 filterGroup ) = 0;

		//! @brief tB^[}XN擾܂
		//! @return tB^[}XNԂ܂
		virtual UInt16 GetFilterMask( void ) const = 0;
		//! @brief tB^[}XNݒ肵܂
		//! @param[in] filterMask tB^[}XN
		virtual void SetFilterMask( UInt16 filterMask ) = 0;
	};

}}
